/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.es.v7;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Requests;
import reactor.core.publisher.Mono;

public class ElasticSearchHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("ElasticSearch Backend");
    private final Set<IndexName> indexNames;
    private final ReactorElasticSearchClient client;

    @Inject
    ElasticSearchHealthCheck(ReactorElasticSearchClient client, Set<IndexName> indexNames) {
        this.client = client;
        this.indexNames = indexNames;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        String[] indices = (String[])this.indexNames.stream().map(IndexName::getValue).toArray(String[]::new);
        ClusterHealthRequest request = Requests.clusterHealthRequest((String[])indices);
        return this.client.health(request).map(this::toHealthCheckResult).onErrorResume(IOException.class, e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error while contacting cluster", (Throwable)e)));
    }

    @VisibleForTesting
    Result toHealthCheckResult(ClusterHealthResponse response) {
        switch (response.getStatus()) {
            case GREEN: 
            case YELLOW: {
                return Result.healthy((ComponentName)COMPONENT_NAME);
            }
            case RED: {
                return Result.unhealthy((ComponentName)COMPONENT_NAME, (String)(response.getClusterName() + " status is RED"));
            }
        }
        throw new NotImplementedException("Un-handled ElasticSearch cluster status");
    }
}

