/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.JsonLoader;

public final class TransformerConfiguration
implements Serializable {
    private static final long serialVersionUID = -1057244274380572226L;
    public static final String CLASS_NAME = "class-name";
    public static final String PROPERTIES = "properties";
    private final String className;
    private Map<String, String> properties = new HashMap<String, String>();

    public TransformerConfiguration(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static TransformerConfiguration fromJSON(String jsonString) {
        JsonObject json = JsonLoader.readObject((Reader)new StringReader(jsonString));
        if (!json.containsKey((Object)CLASS_NAME)) {
            return null;
        }
        TransformerConfiguration result = new TransformerConfiguration(json.getString(CLASS_NAME));
        if (json.containsKey((Object)PROPERTIES)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry propEntry : json.getJsonObject(PROPERTIES).entrySet()) {
                if (((JsonValue)propEntry.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                    properties.put((String)propEntry.getKey(), ((JsonString)propEntry.getValue()).getString());
                    continue;
                }
                properties.put((String)propEntry.getKey(), ((JsonValue)propEntry.getValue()).toString());
            }
            result.setProperties(properties);
        }
        return result;
    }

    public TransformerConfiguration setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransformerConfiguration other = (TransformerConfiguration)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

