/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class CassandraIndexTableHandler {
    private final CassandraMailboxRecentsDAO mailboxRecentDAO;
    private final CassandraMailboxCounterDAO mailboxCounterDAO;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraDeletedMessageDAO deletedMessageDAO;

    @Inject
    public CassandraIndexTableHandler(CassandraMailboxRecentsDAO mailboxRecentDAO, CassandraMailboxCounterDAO mailboxCounterDAO, CassandraFirstUnseenDAO firstUnseenDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraDeletedMessageDAO deletedMessageDAO) {
        this.mailboxRecentDAO = mailboxRecentDAO;
        this.mailboxCounterDAO = mailboxCounterDAO;
        this.firstUnseenDAO = firstUnseenDAO;
        this.applicableFlagDAO = applicableFlagDAO;
        this.deletedMessageDAO = deletedMessageDAO;
    }

    public Mono<Void> updateIndexOnDelete(ComposedMessageIdWithMetaData composedMessageIdWithMetaData, CassandraId mailboxId) {
        MessageUid uid = composedMessageIdWithMetaData.getComposedMessageId().getUid();
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.updateFirstUnseenOnDelete(mailboxId, composedMessageIdWithMetaData.getFlags(), composedMessageIdWithMetaData.getComposedMessageId().getUid()), this.mailboxRecentDAO.removeFromRecent(mailboxId, composedMessageIdWithMetaData.getComposedMessageId().getUid()), this.updateDeletedMessageProjectionOnDelete(mailboxId, uid, composedMessageIdWithMetaData.getFlags()), this.decrementCountersOnDelete(mailboxId, composedMessageIdWithMetaData.getFlags())}).then();
    }

    public Mono<Void> updateIndexOnDelete(CassandraId mailboxId, Collection<MessageMetaData> metaData) {
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{Flux.fromIterable(metaData).flatMap(message -> this.updateFirstUnseenOnDelete(mailboxId, message.getFlags(), message.getUid()), 16), Flux.fromIterable(metaData).flatMap(message -> this.updateRecentOnDelete(mailboxId, message.getUid(), message.getFlags()), 16), Flux.fromIterable(metaData).flatMap(message -> this.updateDeletedMessageProjectionOnDelete(mailboxId, message.getUid(), message.getFlags()), 16), this.decrementCountersOnDelete(mailboxId, metaData)}).then();
    }

    public Mono<Void> updateIndexOnDeleteComposedId(CassandraId mailboxId, Collection<ComposedMessageIdWithMetaData> metaData) {
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{Flux.fromIterable(metaData).flatMap(message -> this.updateFirstUnseenOnDelete(mailboxId, message.getFlags(), message.getComposedMessageId().getUid()), 16), Flux.fromIterable(metaData).flatMap(message -> this.updateRecentOnDelete(mailboxId, message.getComposedMessageId().getUid(), message.getFlags()), 16), Flux.fromIterable(metaData).flatMap(message -> this.updateDeletedMessageProjectionOnDelete(mailboxId, message.getComposedMessageId().getUid(), message.getFlags()), 16), this.decrementCountersOnDeleteFlags(mailboxId, (Collection)metaData.stream().map(ComposedMessageIdWithMetaData::getFlags).collect(ImmutableList.toImmutableList()))}).then();
    }

    private Mono<Void> updateRecentOnDelete(CassandraId mailboxId, MessageUid uid, Flags flags) {
        if (flags.contains(Flags.Flag.RECENT)) {
            return this.mailboxRecentDAO.removeFromRecent(mailboxId, uid);
        }
        return Mono.empty();
    }

    private Mono<Void> updateDeletedMessageProjectionOnDelete(CassandraId mailboxId, MessageUid uid, Flags flags) {
        if (flags.contains(Flags.Flag.DELETED)) {
            return this.deletedMessageDAO.removeDeleted(mailboxId, uid);
        }
        return Mono.empty();
    }

    public Mono<Void> updateIndexOnAdd(MailboxMessage message, CassandraId mailboxId) {
        Flags flags = message.createFlags();
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.checkDeletedOnAdd(mailboxId, message.createFlags(), message.getUid()), this.updateFirstUnseenOnAdd(mailboxId, message.createFlags(), message.getUid()), this.addRecentOnSave(mailboxId, message), this.incrementCountersOnSave(mailboxId, flags), this.applicableFlagDAO.updateApplicableFlags(mailboxId, (Set<String>)ImmutableSet.copyOf((Object[])flags.getUserFlags()))}).then();
    }

    public Mono<Void> updateIndexOnAdd(Collection<MailboxMessage> messages, CassandraId mailboxId) {
        int lowConcurrency = 2;
        ImmutableSet userFlags = (ImmutableSet)messages.stream().flatMap(message -> Stream.of(message.createFlags().getUserFlags())).collect(ImmutableSet.toImmutableSet());
        List flags = (List)messages.stream().flatMap(message -> Stream.of(message.createFlags())).collect(ImmutableList.toImmutableList());
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{Flux.fromIterable(messages).flatMap(message -> this.checkDeletedOnAdd(mailboxId, message.createFlags(), message.getUid()), lowConcurrency), Flux.fromIterable(messages).flatMap(message -> this.updateFirstUnseenOnAdd(mailboxId, message.createFlags(), message.getUid()), lowConcurrency), Flux.fromIterable(messages).flatMap(message -> this.addRecentOnSave(mailboxId, (MailboxMessage)message), lowConcurrency), this.incrementCountersOnSave(mailboxId, flags), this.applicableFlagDAO.updateApplicableFlags(mailboxId, (Set<String>)userFlags)}).then();
    }

    public Mono<Void> updateIndexOnFlagsUpdate(CassandraId mailboxId, UpdatedFlags updatedFlags) {
        return this.updateIndexOnFlagsUpdate(mailboxId, (List<UpdatedFlags>)ImmutableList.of((Object)updatedFlags));
    }

    public Mono<Void> updateIndexOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return Flux.mergeDelayError((int)Queues.XS_BUFFER_SIZE, (Publisher[])new Publisher[]{this.manageUnseenMessageCountsOnFlagsUpdate(mailboxId, updatedFlags), this.manageRecentOnFlagsUpdate(mailboxId, updatedFlags), this.updateFirstUnseenOnFlagsUpdate(mailboxId, updatedFlags), this.manageApplicableFlagsOnFlagsUpdate(mailboxId, updatedFlags), this.updateDeletedOnFlagsUpdate(mailboxId, updatedFlags)}).then();
    }

    private Mono<Void> manageApplicableFlagsOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return this.applicableFlagDAO.updateApplicableFlags(mailboxId, (Set)updatedFlags.stream().flatMap(flags -> Iterators.toStream((Iterator)flags.userFlagIterator())).collect(ImmutableSet.toImmutableSet()));
    }

    private Mono<Void> updateDeletedOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return Flux.fromIterable(updatedFlags).concatMap(flags -> this.updateDeletedOnFlagsUpdate(mailboxId, (UpdatedFlags)flags)).then();
    }

    private Mono<Void> updateDeletedOnFlagsUpdate(CassandraId mailboxId, UpdatedFlags updatedFlags) {
        if (updatedFlags.isModifiedToSet(Flags.Flag.DELETED)) {
            return this.deletedMessageDAO.addDeleted(mailboxId, updatedFlags.getUid());
        }
        if (updatedFlags.isModifiedToUnset(Flags.Flag.DELETED)) {
            return this.deletedMessageDAO.removeDeleted(mailboxId, updatedFlags.getUid());
        }
        return Mono.empty();
    }

    private Mono<Void> decrementCountersOnDelete(CassandraId mailboxId, Flags flags) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return this.mailboxCounterDAO.decrementCount(mailboxId);
        }
        return this.mailboxCounterDAO.decrementUnseenAndCount(mailboxId);
    }

    private Mono<Void> decrementCountersOnDelete(CassandraId mailboxId, Collection<MessageMetaData> metaData) {
        return this.decrementCountersOnDeleteFlags(mailboxId, (Collection)metaData.stream().map(MessageMetaData::getFlags).collect(ImmutableList.toImmutableList()));
    }

    private Mono<Void> decrementCountersOnDeleteFlags(CassandraId mailboxId, Collection<Flags> flags) {
        long unseenCount = flags.stream().filter(flag -> !flag.contains(Flags.Flag.SEEN)).count();
        return this.mailboxCounterDAO.remove(MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count((long)flags.size()).unseen(unseenCount).build());
    }

    private Mono<Void> incrementCountersOnSave(CassandraId mailboxId, Flags flags) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return this.mailboxCounterDAO.incrementCount(mailboxId);
        }
        return this.mailboxCounterDAO.incrementUnseenAndCount(mailboxId);
    }

    private Mono<Void> incrementCountersOnSave(CassandraId mailboxId, Collection<Flags> flags) {
        long unseenCount = flags.stream().filter(flag -> !flag.contains(Flags.Flag.SEEN)).count();
        return this.mailboxCounterDAO.add(MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count((long)flags.size()).unseen(unseenCount).build());
    }

    private Mono<Void> addRecentOnSave(CassandraId mailboxId, MailboxMessage message) {
        if (message.createFlags().contains(Flags.Flag.RECENT)) {
            return this.mailboxRecentDAO.addToRecent(mailboxId, message.getUid());
        }
        return Mono.empty();
    }

    private Mono<Void> manageUnseenMessageCountsOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        int sum = updatedFlags.stream().mapToInt(flags -> {
            if (flags.isModifiedToUnset(Flags.Flag.SEEN)) {
                return 1;
            }
            if (flags.isModifiedToSet(Flags.Flag.SEEN)) {
                return -1;
            }
            return 0;
        }).sum();
        if (sum != 0) {
            return this.mailboxCounterDAO.add(MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count(0L).unseen((long)sum).build());
        }
        return Mono.empty();
    }

    private Mono<Void> manageRecentOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return Flux.fromIterable(updatedFlags).concatMap(flags -> this.manageRecentOnFlagsUpdate(mailboxId, (UpdatedFlags)flags)).then();
    }

    private Mono<Void> manageRecentOnFlagsUpdate(CassandraId mailboxId, UpdatedFlags updatedFlags) {
        if (updatedFlags.isModifiedToUnset(Flags.Flag.RECENT)) {
            return this.mailboxRecentDAO.removeFromRecent(mailboxId, updatedFlags.getUid());
        }
        if (updatedFlags.isModifiedToSet(Flags.Flag.RECENT)) {
            return this.mailboxRecentDAO.addToRecent(mailboxId, updatedFlags.getUid());
        }
        return Mono.empty();
    }

    private Mono<Void> updateFirstUnseenOnAdd(CassandraId mailboxId, Flags flags, MessageUid uid) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return Mono.empty();
        }
        return this.firstUnseenDAO.addUnread(mailboxId, uid);
    }

    private Mono<Void> checkDeletedOnAdd(CassandraId mailboxId, Flags flags, MessageUid uid) {
        if (flags.contains(Flags.Flag.DELETED)) {
            return this.deletedMessageDAO.addDeleted(mailboxId, uid);
        }
        return Mono.empty();
    }

    private Mono<Void> updateFirstUnseenOnDelete(CassandraId mailboxId, Flags flags, MessageUid uid) {
        if (flags.contains(Flags.Flag.SEEN)) {
            return Mono.empty();
        }
        return this.firstUnseenDAO.removeUnread(mailboxId, uid);
    }

    private Mono<Void> updateFirstUnseenOnFlagsUpdate(CassandraId mailboxId, List<UpdatedFlags> updatedFlags) {
        return Flux.fromIterable(updatedFlags).concatMap(flags -> this.updateFirstUnseenOnFlagsUpdate(mailboxId, (UpdatedFlags)flags)).then();
    }

    private Mono<Void> updateFirstUnseenOnFlagsUpdate(CassandraId mailboxId, UpdatedFlags updatedFlags) {
        if (updatedFlags.isModifiedToUnset(Flags.Flag.SEEN)) {
            return this.firstUnseenDAO.addUnread(mailboxId, updatedFlags.getUid());
        }
        if (updatedFlags.isModifiedToSet(Flags.Flag.SEEN)) {
            return this.firstUnseenDAO.removeUnread(mailboxId, updatedFlags.getUid());
        }
        return Mono.empty();
    }
}

