/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.Instant;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.dto.SerializableReIndexingExecutionFailures;
import org.apache.james.webadmin.dto.WebAdminReprocessingContextInformationDTO;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTask;

public class WebAdminSingleMailboxReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final WebAdminReprocessingContextInformationDTO reprocessingContextInformationDTO;
    private final String mailboxId;

    public static AdditionalInformationDTOModule<SingleMailboxReindexingTask.AdditionalInformation, WebAdminSingleMailboxReindexingTaskAdditionalInformationDTO> serializationModule() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(SingleMailboxReindexingTask.AdditionalInformation.class).convertToDTO(WebAdminSingleMailboxReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> {
            throw new NotImplementedException("Deserialization not implemented for this DTO");
        }).toDTOConverter((details, type) -> new WebAdminSingleMailboxReindexingTaskAdditionalInformationDTO(type, details.getMailboxId(), RunningOptionsDTO.toDTO((ReIndexer.RunningOptions)details.getRunningOptions()), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), details.failures(), details.timestamp())).typeName(SingleMailboxReindexingTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    @JsonCreator
    private WebAdminSingleMailboxReindexingTaskAdditionalInformationDTO(String type, String mailboxId, RunningOptionsDTO runningOptions, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
        this.mailboxId = mailboxId;
        this.reprocessingContextInformationDTO = new WebAdminReprocessingContextInformationDTO(type, runningOptions, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
    }

    public String getType() {
        return this.reprocessingContextInformationDTO.getType();
    }

    public Instant getTimestamp() {
        return this.reprocessingContextInformationDTO.getTimestamp();
    }

    public String getMailboxId() {
        return this.mailboxId;
    }

    public RunningOptionsDTO getRunningOptions() {
        return this.reprocessingContextInformationDTO.getRunningOptions();
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getSuccessfullyReprocessedMailCount();
    }

    public int getFailedReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getFailedReprocessedMailCount();
    }

    public SerializableReIndexingExecutionFailures getMessageFailures() {
        return this.reprocessingContextInformationDTO.getMessageFailures();
    }

    public List<String> getMailboxFailures() {
        return this.reprocessingContextInformationDTO.getMailboxFailures();
    }
}

