/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Limit$;
import org.apache.james.jmap.core.Position$;
import org.apache.james.jmap.core.QueryState$;
import org.apache.james.jmap.json.MailboxQuerySerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.MailboxQueryRequest;
import org.apache.james.jmap.mail.MailboxQueryResponse;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001\u0002\b\u0010\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011)\u0019!C\u0001g!AA\b\u0001B\u0001B\u0003%A\u0007\u0003\u0005>\u0001\t\u0015\r\u0011\"\u0001?\u0011!)\u0005A!A!\u0002\u0013y\u0004\"\u0002$\u0001\t\u00039\u0005bB+\u0001\u0005\u0004%\tE\u0016\u0005\u0007[\u0002\u0001\u000b\u0011B,\t\u000f9\u0004!\u0019!C!_\"1q\u0010\u0001Q\u0001\nADq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\t\u0011R*Y5mE>D\u0018+^3ss6+G\u000f[8e\u0015\t\u0001\u0012#\u0001\u0004nKRDw\u000e\u001a\u0006\u0003%M\tAA[7ba*\u0011A#F\u0001\u0006U\u0006lWm\u001d\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0004E\r*S\"A\b\n\u0005\u0011z!\u0001G'fi\"|GMU3rk&\u0014\u0018N\\4BG\u000e|WO\u001c;JIB\u0011a%K\u0007\u0002O)\u0011\u0001&E\u0001\u0005[\u0006LG.\u0003\u0002+O\t\u0019R*Y5mE>D\u0018+^3ssJ+\u0017/^3ti\u000692/_:uK6l\u0015-\u001b7c_b,7\u000f\u0015:pm&$WM\u001d\t\u0003[Aj\u0011A\f\u0006\u0003_M\tq!\\1jY\n|\u00070\u0003\u00022]\t92+_:uK6l\u0015-\u001b7c_b,7\u000f\u0015:pm&$WM]\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u0007\u0005\u0004\u0018N\u0003\u0002:'\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u001e7\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\u0013aD:fgNLwN\\*vaBd\u0017.\u001a:\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\t\u0002\rI|W\u000f^3t\u0013\t!\u0015IA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0011&S5\n\u0005\u0002#\u0001!)1F\u0002a\u0001Y!)!G\u0002a\u0001i!)QH\u0002a\u0001\u007f!\u0012a!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000ba!\u001b8kK\u000e$(\"\u0001*\u0002\u000b)\fg/\u0019=\n\u0005Q{%AB%oU\u0016\u001cG/\u0001\u0006nKRDw\u000e\u001a(b[\u0016,\u0012a\u0016\t\u00031*t!!W4\u000f\u0005i+gBA.e\u001d\ta6M\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001-G\u0001\u0007yI|w\u000e\u001e \n\u0003aI!AF\f\n\u0005Q)\u0012B\u0001\n\u0014\u0013\t1\u0017#\u0001\u0003d_J,\u0017B\u00015j\u0003)IeN^8dCRLwN\u001c\u0006\u0003MFI!a\u001b7\u0003\u00155+G\u000f[8e\u001d\u0006lWM\u0003\u0002iS\u0006YQ.\u001a;i_\u0012t\u0015-\\3!\u0003Q\u0011X-];je\u0016$7)\u00199bE&d\u0017\u000e^5fgV\t\u0001\u000fE\u0002rkbt!A]:\u0011\u0005yk\u0012B\u0001;\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0004'\u0016$(B\u0001;\u001e!\tIHP\u0004\u0002Zu&\u001110[\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\u0005ut(\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'O\u0003\u0002|S\u0006)\"/Z9vSJ,GmQ1qC\nLG.\u001b;jKN\u0004\u0013!\u00033p!J|7-Z:t))\t)!a\b\u0002$\u0005\u001d\u0012\u0011\u0007\t\u0007\u0003\u000f\t)\"!\u0007\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007y\tyAC\u0002g\u0003#Q!!a\u0005\u0002\u000fI,\u0017m\u0019;pe&!\u0011qCA\u0005\u0005\u0015\u0019Vj\u001c8p!\r\u0011\u00131D\u0005\u0004\u0003;y!!F%om>\u001c\u0017\r^5p]^KG\u000f[\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003CY\u0001\u0019\u00019\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\t\u000f\u0005\u00152\u00021\u0001\u0002\u001a\u0005Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\t\u000f\u0005%2\u00021\u0001\u0002,\u0005qQ.Y5mE>D8+Z:tS>t\u0007cA\u0017\u0002.%\u0019\u0011q\u0006\u0018\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"1\u00111G\u0006A\u0002\u0015\nqA]3rk\u0016\u001cH/\u0001\u0006hKR\u0014V-];fgR$b!!\u000f\u0002R\u0005M\u0003cBA\u001e\u0003\u000b\nY%\n\b\u0005\u0003{\t\tED\u0002_\u0003\u007fI\u0011AH\u0005\u0004\u0003\u0007j\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\nIE\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003\u0007j\u0002\u0003BA\u001e\u0003\u001bJA!a\u0014\u0002J\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\u0005%B\u00021\u0001\u0002,!9\u0011Q\u0005\u0007A\u0002\u0005U\u0003\u0003BA,\u00033j\u0011![\u0005\u0004\u00037J'AC%om>\u001c\u0017\r^5p]\u0006q\u0001O]8dKN\u001c(+Z9vKN$H\u0003CA1\u0003G\n)'a\u001a\u0011\r\u0005\u001d\u0011QCA+\u0011\u001d\tI#\u0004a\u0001\u0003WAq!!\n\u000e\u0001\u0004\t)\u0006\u0003\u0004\u000245\u0001\r!\n")
public class MailboxQueryMethod
implements MethodRequiringAccountId<MailboxQueryRequest> {
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MailboxQueryRequest request) {
        return this.processRequest(mailboxSession, invocation.invocation(), request).onErrorResume((Function1 & Serializable)x0$1 -> {
            SMono sMono;
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                sMono = SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                sMono = SMono$.MODULE$.error(throwable2);
            } else {
                throw new MatchError((Object)throwable);
            }
            return sMono;
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, MailboxQueryRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Right right;
        JsResult<MailboxQueryRequest> jsResult = MailboxQuerySerializer$.MODULE$.deserialize((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MailboxQueryRequest emailQueryRequest = (MailboxQueryRequest)jsSuccess.value();
            right = package$.MODULE$.Right().apply((Object)emailQueryRequest);
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            right = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        } else {
            throw new MatchError(jsResult);
        }
        return right;
    }

    private SMono<Invocation> processRequest(MailboxSession mailboxSession, Invocation invocation, MailboxQueryRequest request) {
        return SFlux$.MODULE$.fromPublisher(this.systemMailboxesProvider.getMailboxByRole(request.filter().role(), mailboxSession.getUser())).map((Function1 & Serializable)x$1 -> x$1.getId()).collectSeq().map((Function1 & Serializable)ids -> new MailboxQueryResponse(request.accountId(), QueryState$.MODULE$.forMailboxIds((Seq<MailboxId>)ids), false, (Seq)ids, Position$.MODULE$.zero(), (Option)new Some((Object)new Refined((Object)Limit$.MODULE$.default())))).map((Function1 & Serializable)response -> new Invocation(this.methodName(), MailboxQuerySerializer$.MODULE$.serialize((MailboxQueryResponse)response), invocation.methodCallId())).subscribeOn(Schedulers.elastic());
    }

    @Inject
    public MailboxQueryMethod(SystemMailboxesProvider systemMailboxesProvider, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Mailbox/query")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

