/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.CanNotCalculateChangesException;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.EmailChanges;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$CannotCalculateChanges$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.EmailGetSerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.EmailChangesRequest;
import org.apache.james.jmap.mail.EmailChangesResponse;
import org.apache.james.jmap.mail.HasMoreChanges$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001B\b\u0011\u0001mA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tm\u0001\u0011\t\u0011)A\u0005]!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003:\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b)\u0003A\u0011A&\t\u000fe\u0003!\u0019!C!5\"1\u0011\u000f\u0001Q\u0001\nmCqA\u001d\u0001C\u0002\u0013\u00053\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u00111\t\u0001\u0005\n\u0005\u0015\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0002\u0013\u000b6\f\u0017\u000e\\\"iC:<Wm]'fi\"|GM\u0003\u0002\u0012%\u00051Q.\u001a;i_\u0012T!a\u0005\u000b\u0002\t)l\u0017\r\u001d\u0006\u0003+Y\tQA[1nKNT!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u00042a\t\u0013'\u001b\u0005\u0001\u0012BA\u0013\u0011\u0005aiU\r\u001e5pIJ+\u0017/^5sS:<\u0017iY2pk:$\u0018\n\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SI\tA!\\1jY&\u00111\u0006\u000b\u0002\u0014\u000b6\f\u0017\u000e\\\"iC:<Wm\u001d*fcV,7\u000f^\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u00024)\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u001b1\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\u0013!F3nC&d7\t[1oO\u0016\u0014V\r]8tSR|'/_\u000b\u0002sA\u0011!HP\u0007\u0002w)\u0011A(P\u0001\u0007G\"\fgnZ3\u000b\u0005E\u0012\u0012BA <\u0005U)U.Y5m\u0007\"\fgnZ3SKB|7/\u001b;pef\fa#Z7bS2\u001c\u0005.\u00198hKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0010g\u0016\u001c8/[8o'V\u0004\b\u000f\\5feV\t1\t\u0005\u0002E\u000f6\tQI\u0003\u0002G%\u00051!o\\;uKNL!\u0001S#\u0003\u001fM+7o]5p]N+\b\u000f\u001d7jKJ\f\u0001c]3tg&|gnU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011aUJT(\u0011\u0005\r\u0002\u0001\"\u0002\u0017\b\u0001\u0004q\u0003\"B\u001c\b\u0001\u0004I\u0004\"B!\b\u0001\u0004\u0019\u0005FA\u0004R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0004j]*,7\r\u001e\u0006\u0002-\u0006)!.\u0019<bq&\u0011\u0001l\u0015\u0002\u0007\u0013:TWm\u0019;\u0002\u00155,G\u000f[8e\u001d\u0006lW-F\u0001\\!\tafN\u0004\u0002^W:\u0011a,\u001b\b\u0003?\"t!\u0001Y4\u000f\u0005\u00054gB\u00012f\u001b\u0005\u0019'B\u00013\u001b\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002\u00181%\u0011QCF\u0005\u0003'QI!A\u001b\n\u0002\t\r|'/Z\u0005\u0003Y6\f!\"\u00138w_\u000e\fG/[8o\u0015\tQ'#\u0003\u0002pa\nQQ*\u001a;i_\u0012t\u0015-\\3\u000b\u00051l\u0017aC7fi\"|GMT1nK\u0002\nAC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cX#\u0001;\u0011\u0007ULHP\u0004\u0002woB\u0011!MH\u0005\u0003qz\ta\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\r\u0019V\r\u001e\u0006\u0003qz\u00012!`A\u0001\u001d\tif0\u0003\u0002\u0000[\u0006!2)\u00199bE&d\u0017\u000e^=JI\u0016tG/\u001b4jKJLA!a\u0001\u0002\u0006\t!2)\u00199bE&d\u0017\u000e^=JI\u0016tG/\u001b4jKJT!a`7\u0002+I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3tA\u0005IAm\u001c)s_\u000e,7o\u001d\u000b\u000b\u0003\u001b\t9#a\u000b\u00020\u0005}\u0002CBA\b\u0003;\t\t#\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003%\u0001XO\u00197jg\",'OC\u0002 \u0003/Q1A[A\r\u0015\t\tY\"A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005}\u0011\u0011\u0003\u0002\u0006'6{gn\u001c\t\u0004G\u0005\r\u0012bAA\u0013!\t)\u0012J\u001c<pG\u0006$\u0018n\u001c8XSRD7i\u001c8uKb$\bBBA\u0015\u0019\u0001\u0007A/\u0001\u0007dCB\f'-\u001b7ji&,7\u000fC\u0004\u0002.1\u0001\r!!\t\u0002\u0015%tgo\\2bi&|g\u000eC\u0004\u000221\u0001\r!a\r\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:Q\tq!\\1jY\n|\u00070\u0003\u0003\u0002>\u0005]\"AD'bS2\u0014w\u000e_*fgNLwN\u001c\u0005\u0007\u0003\u0003b\u0001\u0019\u0001\u0014\u0002\u000fI,\u0017/^3ti\u0006y!/\u001a;sS\u00164Xm\u00115b]\u001e,7\u000f\u0006\u0005\u0002H\u0005=\u0013\u0011KA*!\u0019\ty!!\b\u0002JA\u0019!(a\u0013\n\u0007\u000553H\u0001\u0007F[\u0006LGn\u00115b]\u001e,7\u000f\u0003\u0004\u0002*5\u0001\r\u0001\u001e\u0005\b\u0003ci\u0001\u0019AA\u001a\u0011\u0019\t\t%\u0004a\u0001M\u0005Qq-\u001a;SKF,Xm\u001d;\u0015\r\u0005e\u0013\u0011OA:!\u001d\tY&!\u001a\u0002l\u0019rA!!\u0018\u0002b9\u0019!-a\u0018\n\u0003}I1!a\u0019\u001f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\t1Q)\u001b;iKJT1!a\u0019\u001f!\u0011\tY&!\u001c\n\t\u0005=\u0014\u0011\u000e\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBA\u0019\u001d\u0001\u0007\u00111\u0007\u0005\b\u0003[q\u0001\u0019AA;!\u0011\t9(!\u001f\u000e\u00035L1!a\u001fn\u0005)IeN^8dCRLwN\u001c")
public class EmailChangesMethod
implements MethodRequiringAccountId<EmailChangesRequest> {
    private final MetricFactory metricFactory;
    private final EmailChangeRepository emailChangeRepository;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public EmailChangeRepository emailChangeRepository() {
        return this.emailChangeRepository;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, EmailChangesRequest request) {
        return this.retrieveChanges(capabilities, mailboxSession, request).map((Function1 & Serializable)emailChanges -> new EmailChangesResponse(request.accountId(), request.sinceState(), UuidState$.MODULE$.fromEmailChanges((EmailChanges)emailChanges), HasMoreChanges$.MODULE$.fromEmailChanges((EmailChanges)emailChanges), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getCreated()).asScala().toSet(), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getUpdated()).asScala().toSet(), (Set<MessageId>)CollectionConverters$.MODULE$.SetHasAsScala(emailChanges.getDestroyed()).asScala().toSet())).map((Function1 & Serializable)response -> new InvocationWithContext(new Invocation(this.methodName(), EmailGetSerializer$.MODULE$.serializeChanges((EmailChangesResponse)response), invocation.invocation().methodCallId()), invocation.processingContext())).onErrorResume((Function1 & Serializable)x0$1 -> {
            SMono sMono;
            Throwable throwable = x0$1;
            if (throwable instanceof CanNotCalculateChangesException) {
                CanNotCalculateChangesException canNotCalculateChangesException = (CanNotCalculateChangesException)throwable;
                sMono = SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$CannotCalculateChanges$.MODULE$, canNotCalculateChangesException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext()));
            } else {
                sMono = SMono$.MODULE$.error(throwable);
            }
            return sMono;
        });
    }

    private SMono<EmailChanges> retrieveChanges(Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, EmailChangesRequest request) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        return capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES())) ? SMono$.MODULE$.apply((Publisher)this.emailChangeRepository().getSinceStateWithDelegation(accountId, State.of((UUID)request.sinceState().value()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(request.maxChanges())))) : SMono$.MODULE$.apply((Publisher)this.emailChangeRepository().getSinceState(accountId, State.of((UUID)request.sinceState().value()), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(request.maxChanges()))));
    }

    @Override
    public Either<IllegalArgumentException, EmailChangesRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Right right;
        JsResult<EmailChangesRequest> jsResult = EmailGetSerializer$.MODULE$.deserializeEmailChangesRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            EmailChangesRequest emailGetRequest = (EmailChangesRequest)jsSuccess.value();
            right = package$.MODULE$.Right().apply((Object)emailGetRequest);
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            right = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        } else {
            throw new MatchError(jsResult);
        }
        return right;
    }

    @Inject
    public EmailChangesMethod(MetricFactory metricFactory, EmailChangeRepository emailChangeRepository, SessionSupplier sessionSupplier) {
        this.metricFactory = metricFactory;
        this.emailChangeRepository = emailChangeRepository;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Email/changes")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

