/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.base.CharMatcher;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.api.Validate;
import eu.timepit.refined.api.Validate$;
import eu.timepit.refined.auto$;
import eu.timepit.refined.package$;
import java.io.Serializable;
import java.util.Base64;
import org.apache.james.core.Username;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.UserCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class UserCredential$
implements Serializable {
    public static final UserCredential$ MODULE$ = new UserCredential$();
    private static final CharMatcher charMatcher = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'=')).or(CharMatcher.is((char)'-')).or(CharMatcher.is((char)'#'));
    private static final Validate<String, UserCredential.CredentialsAsStringConstraint> validateCredentialsAsString = Validate$.MODULE$.fromPredicate((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), ':')), (Function1 & Serializable)x$1 -> "Credential string must contains ':'", (Object)new UserCredential.CredentialsAsStringConstraint());
    private static final Validate<String, UserCredential.BasicAuthenticationHeaderValueConstraint> validateBasicAuthenticationHeaderValueConstraint = Validate$.MODULE$.fromPredicate((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UserCredential$.$anonfun$validateBasicAuthenticationHeaderValueConstraint$1(s)), (Function1 & Serializable)x$2 -> "Must start with 'Basic' prefix then be only letter or digits", (Object)new UserCredential.BasicAuthenticationHeaderValueConstraint());
    private static final Logger logger = LoggerFactory.getLogger(UserCredential.class);
    private static final String BASIC_AUTHENTICATION_PREFIX = "Basic ";

    private CharMatcher charMatcher() {
        return charMatcher;
    }

    public Validate<String, UserCredential.CredentialsAsStringConstraint> validateCredentialsAsString() {
        return validateCredentialsAsString;
    }

    public Validate<String, UserCredential.BasicAuthenticationHeaderValueConstraint> validateBasicAuthenticationHeaderValueConstraint() {
        return validateBasicAuthenticationHeaderValueConstraint;
    }

    private Logger logger() {
        return logger;
    }

    private String BASIC_AUTHENTICATION_PREFIX() {
        return BASIC_AUTHENTICATION_PREFIX;
    }

    public Option<UserCredential> parseUserCredentials(String token) {
        Option<UserCredential> option;
        Either refinedValue = package$.MODULE$.refineV().apply((Object)token, this.validateBasicAuthenticationHeaderValueConstraint());
        Either either = refinedValue;
        if (either instanceof Left) {
            option = None$.MODULE$;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String value = (String)((Refined)right.value()).value();
            option = this.extractUserCredentialsAsString(value);
        } else {
            throw new MatchError((Object)either);
        }
        return option;
    }

    private Option<UserCredential> extractUserCredentialsAsString(String token) {
        Left left;
        String errorMessage;
        String encodedCredentials = ((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)token), RefType$.MODULE$.refinedRefType())).substring(this.BASIC_AUTHENTICATION_PREFIX().length());
        String decodedCredentialsString = new String(Base64.getDecoder().decode(encodedCredentials));
        Either refinedValue = package$.MODULE$.refineV().apply((Object)decodedCredentialsString, this.validateCredentialsAsString());
        Either either = refinedValue;
        if (either instanceof Left && (errorMessage = (String)(left = (Left)either).value()) != null) {
            String string2 = errorMessage;
            throw new UnauthorizedException(new StringBuilder(72).append("Supplied basic authentication credentials do not match expected format. ").append(string2).toString());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        String value = (String)((Refined)right.value()).value();
        Option<UserCredential> option = this.toCredential(value);
        return option;
    }

    private Option<UserCredential> toCredential(String token) {
        int partSeparatorIndex = ((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)token), RefType$.MODULE$.refinedRefType())).indexOf(58);
        String usernameString = ((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)token), RefType$.MODULE$.refinedRefType())).substring(0, partSeparatorIndex);
        String passwordString = ((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)token), RefType$.MODULE$.refinedRefType())).substring(partSeparatorIndex + 1);
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new UserCredential(Username.of((String)usernameString), passwordString));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable throwable = failure.exception();
                if (throwable instanceof IllegalArgumentException) {
                    IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                    throw new UnauthorizedException("Username is not valid", (Throwable)illegalArgumentException);
                }
            }
            if (bl) {
                Throwable unexpectedException = failure.exception();
                this.logger().error("Unexpected Exception", unexpectedException);
                throw unexpectedException;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        UserCredential credential = (UserCredential)success.value();
        Some some = new Some((Object)credential);
        return some;
    }

    public UserCredential apply(Username username, String password) {
        return new UserCredential(username, password);
    }

    public Option<Tuple2<Username, String>> unapply(UserCredential x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.username(), (Object)x$0.password()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UserCredential$.class);
    }

    public static final /* synthetic */ boolean $anonfun$validateBasicAuthenticationHeaderValueConstraint$1(String s) {
        return s.startsWith("Basic ") && MODULE$.charMatcher().matchesAllOf((CharSequence)s.substring(6));
    }

    private UserCredential$() {
    }
}

