/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

final class ParallelPoolConnectorTask
implements Runnable {
    @NotNull
    private final AtomicReference<LDAPException> firstException;
    private final boolean throwOnConnectFailure;
    @NotNull
    private final LDAPConnectionPool pool;
    @NotNull
    private final List<LDAPConnection> connList;

    ParallelPoolConnectorTask(@NotNull LDAPConnectionPool pool, @NotNull List<LDAPConnection> connList, @NotNull AtomicReference<LDAPException> firstException, boolean throwOnConnectFailure) {
        this.pool = pool;
        this.connList = connList;
        this.firstException = firstException;
        this.throwOnConnectFailure = throwOnConnectFailure;
    }

    @Override
    public void run() {
        block3: {
            try {
                if (this.throwOnConnectFailure && this.firstException.get() != null) {
                    return;
                }
                this.connList.add(this.pool.createConnection());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (!this.throwOnConnectFailure) break block3;
                this.firstException.compareAndSet(null, le);
            }
        }
    }
}

