/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.apache.james.task.eventsourcing.CancelCommandHandler;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.CompleteCommandHandler;
import org.apache.james.task.eventsourcing.CreateCommandHandler;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.FailCommandHandler;
import org.apache.james.task.eventsourcing.RequestCancelCommandHandler;
import org.apache.james.task.eventsourcing.StartCommandHandler;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskCommand;
import org.apache.james.task.eventsourcing.TaskEvent;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TerminationSubscriber;
import org.apache.james.task.eventsourcing.UpdateCommandHandler;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u000f\u001e\u0001!B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011)\u0019!C\u0001\u0013\"A\u0011\u000b\u0001B\u0001B\u0003%!\n\u0003\u0005S\u0001\t\u0015\r\u0011\"\u0001T\u0011!9\u0006A!A!\u0002\u0013!\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011A-\t\u0011u\u0003!\u0011!Q\u0001\niC\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005A\"1A\r\u0001C\u0001;\u0015Dq!!\u0002\u0001\t\u0013\t9\u0001C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\t\u0001!\u0002\u0013\t)\u0002C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H!A\u0011q\n\u0001!\u0002\u0013\tI\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u00111\f\u0001!\u0002\u0013\t)\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002`!9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\tI\t\u0001C!\u00033Cq!!,\u0001\t\u0013\ty\u000bC\u0004\u0002H\u0002!\t%!3\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9!\u0011\u0003\u0001\u0005B\u0005}#\u0001G#wK:$8k\\;sG&tw\rV1tW6\u000bg.Y4fe*\u0011adH\u0001\u000eKZ,g\u000e^:pkJ\u001c\u0017N\\4\u000b\u0005\u0001\n\u0013\u0001\u0002;bg.T!AI\u0012\u0002\u000b)\fW.Z:\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011&M\u001b<!\tQs&D\u0001,\u0015\taS&\u0001\u0003mC:<'\"\u0001\u0018\u0002\t)\fg/Y\u0005\u0003a-\u0012aa\u00142kK\u000e$\bC\u0001\u001a4\u001b\u0005y\u0012B\u0001\u001b \u0005-!\u0016m]6NC:\fw-\u001a:\u0011\u0005YJT\"A\u001c\u000b\u0005aj\u0013AA5p\u0013\tQtGA\u0005DY>\u001cX-\u00192mKB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0004CBL'B\u0001!\"\u0003%a\u0017NZ3ds\u000edW-\u0003\u0002C{\tI1\u000b^1si\u0006\u0014G.Z\u0001\u0012o>\u00148.U;fk\u0016\u001cV\u000f\u001d9mS\u0016\u0014\bCA#G\u001b\u0005i\u0012BA$\u001e\u0005E9vN]6Rk\u0016,XmU;qa2LWM]\u0001\u000bKZ,g\u000e^*u_J,W#\u0001&\u0011\u0005-{U\"\u0001'\u000b\u00055s\u0015AC3wK:$8\u000f^8sK*\u0011a$I\u0005\u0003!2\u0013!\"\u0012<f]R\u001cFo\u001c:f\u0003-)g/\u001a8u'R|'/\u001a\u0011\u00025\u0015DXmY;uS>tG)\u001a;bS2\u001c\bK]8kK\u000e$\u0018n\u001c8\u0016\u0003Q\u0003\"!R+\n\u0005Yk\"A\b+bg.,\u00050Z2vi&|g\u000eR3uC&d7\u000f\u0015:pU\u0016\u001cG/[8o\u0003m)\u00070Z2vi&|g\u000eR3uC&d7\u000f\u0015:pU\u0016\u001cG/[8oA\u0005A\u0001n\\:u]\u0006lW-F\u0001[!\t\u00114,\u0003\u0002]?\tA\u0001j\\:u]\u0006lW-A\u0005i_N$h.Y7fA\u0005)B/\u001a:nS:\fG/[8o'V\u00147o\u0019:jE\u0016\u0014X#\u00011\u0011\u0005\u0015\u000b\u0017B\u00012\u001e\u0005U!VM]7j]\u0006$\u0018n\u001c8Tk\n\u001c8M]5cKJ\fa\u0003^3s[&t\u0017\r^5p]N+(m]2sS\n,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0019<\u0007.\u001b6l!\t)\u0005\u0001C\u0003D\u0015\u0001\u0007A\tC\u0003I\u0015\u0001\u0007!\nC\u0003S\u0015\u0001\u0007A\u000bC\u0003Y\u0015\u0001\u0007!\fC\u0003_\u0015\u0001\u0007\u0001\r\u000b\u0002\u000b[B\u0011an^\u0007\u0002_*\u0011\u0001/]\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002sg\u000611m\\7n_:T!\u0001^;\u0002\r\u001d|wn\u001a7f\u0015\u00051\u0018aA2p[&\u0011\u0001p\u001c\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007F\u0001\u0006{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0007S:TWm\u0019;\u000b\u0003}\fQA[1wCbL1!a\u0001}\u0005\u0019IeN[3di\u0006qqo\u001c:l\t&\u001c\b/\u0019;dQ\u0016\u0014XCAA\u0005!\u0011\tY!!\u0004\u000e\u00039K1!a\u0004O\u0005)\u0019VOY:de&\u0014WM]\u0001\fY>\fG\rS5ti>\u0014\u00180\u0006\u0002\u0002\u0016AA\u0011qCA\u000f\u0003C\t9#\u0004\u0002\u0002\u001a)\u0011\u00111D\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003?\tIBA\u0005Gk:\u001cG/[8ocA!\u00111BA\u0012\u0013\r\t)C\u0014\u0002\f\u0003\u001e<'/Z4bi\u0016LE\r\u0005\u0004\u0002*\u0005e\u0012QH\u0007\u0003\u0003WQA!!\f\u00020\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0005\u00037\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001B2pe\u0016T!!a\u000e\u0002\u000fI,\u0017m\u0019;pe&!\u00111HA\u0016\u0005\u0015\u0019Vj\u001c8p!\rY\u0015qH\u0005\u0004\u0003\u0003b%a\u0002%jgR|'/_\u0001\rY>\fG\rS5ti>\u0014\u0018\u0010I\u0001\u0014KZ,g\u000e^*pkJ\u001c\u0017N\\4TsN$X-\\\u000b\u0003\u0003\u0013\u0002B!a\u0003\u0002L%\u0019\u0011Q\n(\u0003'\u00153XM\u001c;T_V\u00148-\u001b8h'f\u001cH/Z7\u0002)\u00154XM\u001c;T_V\u00148-\u001b8h'f\u001cH/Z7!\u0003%9xN]6Rk\u0016,X-\u0006\u0002\u0002VA\u0019!'a\u0016\n\u0007\u0005esDA\u0005X_J\\\u0017+^3vK\u0006Qqo\u001c:l#V,W/\u001a\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\u0005\u0004\u0003BA\f\u0003GJA!!\u001a\u0002\u001a\t!QK\\5u\u0003\u001d\u0011Xm\u001d;beR\faa];c[&$H\u0003BA7\u0003g\u00022AMA8\u0013\r\t\th\b\u0002\u0007)\u0006\u001c8.\u00133\t\r\u0001\"\u0002\u0019AA;!\r\u0011\u0014qO\u0005\u0004\u0003sz\"\u0001\u0002+bg.\f1cZ3u\u000bb,7-\u001e;j_:$U\r^1jYN$B!a \u0002\u0006B\u0019!'!!\n\u0007\u0005\ruD\u0001\u000bUCN\\W\t_3dkRLwN\u001c#fi\u0006LGn\u001d\u0005\b\u0003\u000f+\u0002\u0019AA7\u0003\tIG-\u0001\u0003mSN$HCAAG!\u0019\ty)!&\u0002\u00005\u0011\u0011\u0011\u0013\u0006\u0004\u0003'k\u0013\u0001B;uS2LA!a&\u0002\u0012\n!A*[:u)\u0011\ti)a'\t\u000f\u0005uu\u00031\u0001\u0002 \u000611\u000f^1ukN\u0004B!!)\u0002(:\u0019!'a)\n\u0007\u0005\u0015v$A\u0006UCN\\W*\u00198bO\u0016\u0014\u0018\u0002BAU\u0003W\u0013aa\u0015;biV\u001c(bAAS?\u0005IA.[:u'\u000e\fG.Y\u000b\u0003\u0003c\u0003b!a-\u0002D\u0006}d\u0002BA[\u0003\u007fsA!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w;\u0013A\u0002\u001fs_>$h(\u0003\u0002\u0002\u001c%!\u0011\u0011YA\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!a&\u0002F*!\u0011\u0011YA\r\u0003\u0019\u0019\u0017M\\2fYR!\u0011\u0011MAf\u0011\u001d\t9)\u0007a\u0001\u0003[\nQ!Y<bSR$b!a \u0002R\u0006M\u0007bBAD5\u0001\u0007\u0011Q\u000e\u0005\b\u0003+T\u0002\u0019AAl\u0003\u001d!\u0018.\\3pkR\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0004\u0003;l\u0013\u0001\u0002;j[\u0016LA!!9\u0002\\\nAA)\u001e:bi&|g\u000eK\u0003\u001b\u0003K\u0014\u0019\u0001\u0005\u0004\u0002\u0018\u0005\u001d\u00181^\u0005\u0005\u0003S\fIB\u0001\u0004uQJ|wo\u001d\t\u0005\u0003[\fyP\u0004\u0003\u0002p\u0006\rf\u0002BAy\u0003{tA!a=\u0002|:!\u0011Q_A}\u001d\u0011\t9,a>\n\u0003\u0019J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\u0011\u0011\t!a+\u0003/I+\u0017m\u00195fIRKW.Z8vi\u0016C8-\u001a9uS>t7EAAvQ\u0015Q\"q\u0001B\b!\u0019\t9\"a:\u0003\nA\u0019!Ga\u0003\n\u0007\t5qDA\u000bUCN\\gj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8$\u0005\t%\u0011!B2m_N,\u0007fA\u000e\u0003\u0016A!!q\u0003B\u000f\u001b\t\u0011IBC\u0002\u0003\u001cy\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yB!\u0007\u0003\u0015A\u0013X\rR3tiJ|\u0017\u0010")
public class EventSourcingTaskManager
implements TaskManager,
Closeable,
Startable {
    private final EventStore eventStore;
    private final TaskExecutionDetailsProjection executionDetailsProjection;
    private final Hostname hostname;
    private final TerminationSubscriber terminationSubscriber;
    private final Function1<AggregateId, SMono<History>> loadHistory;
    private final EventSourcingSystem eventSourcingSystem;
    private final WorkQueue workQueue;

    public EventStore eventStore() {
        return this.eventStore;
    }

    public TaskExecutionDetailsProjection executionDetailsProjection() {
        return this.executionDetailsProjection;
    }

    public Hostname hostname() {
        return this.hostname;
    }

    public TerminationSubscriber terminationSubscriber() {
        return this.terminationSubscriber;
    }

    private Subscriber workDispatcher() {
        return x0$1 -> {
            Event event = x0$1;
            if (event instanceof Created) {
                Created created = (Created)event;
                TaskAggregateId aggregateId = created.aggregateId();
                Task task = created.task();
                TaskWithId taskWithId = new TaskWithId(aggregateId.taskId(), task);
                this.workQueue().submit(taskWithId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (event instanceof CancelRequested) {
                CancelRequested cancelRequested = (CancelRequested)event;
                TaskAggregateId aggregateId = cancelRequested.aggregateId();
                this.workQueue().cancel(aggregateId.taskId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        };
    }

    private Function1<AggregateId, SMono<History>> loadHistory() {
        return this.loadHistory;
    }

    private EventSourcingSystem eventSourcingSystem() {
        return this.eventSourcingSystem;
    }

    private WorkQueue workQueue() {
        return this.workQueue;
    }

    public void start() {
        this.workQueue().start();
    }

    public void restart() {
        this.workQueue().restart();
    }

    /*
     * WARNING - void declaration
     */
    public TaskId submit(Task task) {
        void var2_2;
        TaskId taskId = TaskId.generateTaskId();
        TaskCommand.Create command = new TaskCommand.Create(taskId, task);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
        return var2_2;
    }

    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return (TaskExecutionDetails)this.executionDetailsProjection().load(id).getOrElse((Function0 & Serializable)() -> {
            throw new TaskNotFoundException();
        });
    }

    public java.util.List<TaskExecutionDetails> list() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.listScala()).asJava();
    }

    public java.util.List<TaskExecutionDetails> list(TaskManager.Status status) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.listScala().filter((Function1 & Serializable)details -> BoxesRunTime.boxToBoolean((boolean)EventSourcingTaskManager.$anonfun$list$1(status, details)))).asJava();
    }

    private List<TaskExecutionDetails> listScala() {
        return this.executionDetailsProjection().list();
    }

    public void cancel(TaskId id) {
        TaskCommand.RequestCancel command = new TaskCommand.RequestCancel(id);
        SMono qual$1 = SMono$.MODULE$.apply(this.eventSourcingSystem().dispatch((Command)command));
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    public TaskExecutionDetails await(TaskId id, java.time.Duration timeout) throws TaskNotFoundException, TaskManager.ReachedTimeoutException {
        TaskExecutionDetails taskExecutionDetails;
        try {
            Mono details = Mono.fromSupplier(() -> this.getExecutionDetails(id)).filter(x$1 -> x$1.getStatus().isFinished());
            Mono findEvent = Flux.from(this.terminationSubscriber().listenEvents()).filter(x0$1 -> {
                boolean bl;
                Event event = x0$1;
                if (event instanceof TaskEvent) {
                    TaskEvent taskEvent = (TaskEvent)event;
                    TaskId taskId = taskEvent.getAggregateId().taskId();
                    TaskId taskId2 = id;
                    bl = !(taskId != null ? !taskId.equals(taskId2) : taskId2 != null);
                } else {
                    bl = false;
                }
                return bl;
            }).next().then(details);
            taskExecutionDetails = (TaskExecutionDetails)Flux.merge((Publisher[])new Publisher[]{findEvent, details}).subscribeOn(Schedulers.elastic()).blockFirst(timeout);
        }
        catch (IllegalStateException illegalStateException) {
            throw new TaskManager.ReachedTimeoutException();
        }
        return taskExecutionDetails;
    }

    @Override
    @PreDestroy
    public void close() {
        this.workQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$list$1(TaskManager.Status status$1, TaskExecutionDetails details) {
        TaskManager.Status status = details.getStatus();
        TaskManager.Status status2 = status$1;
        return !(status != null ? !status.equals(status2) : status2 != null);
    }

    @Inject
    @VisibleForTesting
    public EventSourcingTaskManager(WorkQueueSupplier workQueueSupplier, EventStore eventStore, TaskExecutionDetailsProjection executionDetailsProjection, Hostname hostname, TerminationSubscriber terminationSubscriber) {
        this.eventStore = eventStore;
        this.executionDetailsProjection = executionDetailsProjection;
        this.hostname = hostname;
        this.terminationSubscriber = terminationSubscriber;
        this.loadHistory = (Function1 & Serializable)aggregateId -> SMono$.MODULE$.apply(this.eventStore().getEventsOfAggregate(aggregateId));
        this.eventSourcingSystem = new EventSourcingSystem((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CommandHandler[]{new CreateCommandHandler(this.loadHistory(), hostname), new StartCommandHandler(this.loadHistory(), hostname), new RequestCancelCommandHandler(this.loadHistory(), hostname), new CompleteCommandHandler(this.loadHistory()), new CancelCommandHandler(this.loadHistory()), new FailCommandHandler(this.loadHistory()), new UpdateCommandHandler(this.loadHistory())})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Subscriber[]{executionDetailsProjection.asSubscriber(hostname), this.workDispatcher(), terminationSubscriber})), eventStore);
        this.workQueue = workQueueSupplier.apply(this.eventSourcingSystem());
    }
}

