/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.listeners;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossing;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossingHandler;
import org.apache.james.mailbox.quota.mailing.subscribers.QuotaThresholdMailer;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.MailetContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class QuotaThresholdCrossingListener
implements EventListener.ReactiveGroupEventListener {
    private static final Group GROUP = new QuotaThresholdCrossingListenerGroup();
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public QuotaThresholdCrossingListener(MailetContext mailetContext, UsersRepository usersRepository, FileSystem fileSystem, EventStore eventStore, HierarchicalConfiguration<ImmutableNode> config) {
        this(mailetContext, usersRepository, fileSystem, eventStore, QuotaMailingListenerConfiguration.from(config));
    }

    public QuotaThresholdCrossingListener(MailetContext mailetContext, UsersRepository usersRepository, FileSystem fileSystem, EventStore eventStore, QuotaMailingListenerConfiguration config) {
        ImmutableSet handlers = ImmutableSet.of((Object)new DetectThresholdCrossingHandler(eventStore, config));
        ImmutableSet subscribers = ImmutableSet.of((Object)new QuotaThresholdMailer(mailetContext, usersRepository, fileSystem, config));
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)handlers, (Set)subscribers, (EventStore)eventStore);
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.QuotaUsageUpdatedEvent;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.QuotaUsageUpdatedEvent) {
            return this.handleEvent(event.getUsername(), (MailboxEvents.QuotaUsageUpdatedEvent)event);
        }
        return Mono.empty();
    }

    private Mono<Void> handleEvent(Username username, MailboxEvents.QuotaUsageUpdatedEvent event) {
        return Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new DetectThresholdCrossing(username, (Quota<QuotaCountLimit, QuotaCountUsage>)event.getCountQuota(), (Quota<QuotaSizeLimit, QuotaSizeUsage>)event.getSizeQuota(), event.getInstant()))).then();
    }

    public static class QuotaThresholdCrossingListenerGroup
    extends Group {
    }
}

