/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportWriteAction<Request extends ReplicatedWriteRequest<Request>, ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, ReplicaRequest, Response> {
    protected final IndexingPressure indexingPressure;
    protected final SystemIndices systemIndices;
    private final Function<IndexShard, String> executorFunction;

    protected TransportWriteAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, Writeable.Reader<Request> request, Writeable.Reader<ReplicaRequest> replicaRequest, Function<IndexShard, String> executorFunction, boolean forceExecutionOnPrimary, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        super(settings, actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, request, replicaRequest, "same", true, forceExecutionOnPrimary);
        this.executorFunction = executorFunction;
        this.indexingPressure = indexingPressure;
        this.systemIndices = systemIndices;
    }

    protected String executor(IndexShard shard) {
        return this.executorFunction.apply(shard);
    }

    @Override
    protected Releasable checkOperationLimits(Request request) {
        return this.indexingPressure.markPrimaryOperationStarted(this.primaryOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected boolean force(ReplicatedWriteRequest<?> request) {
        return this.forceExecutionOnPrimary || this.isSystemShard(request.shardId);
    }

    protected boolean isSystemShard(ShardId shardId) {
        IndexAbstraction abstraction = (IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(shardId.getIndexName());
        return abstraction != null ? abstraction.isSystem() : this.systemIndices.isSystemIndex(shardId.getIndexName());
    }

    @Override
    protected Releasable checkPrimaryLimits(Request request, boolean rerouteWasLocal, boolean localRerouteInitiatedByNodeClient) {
        if (rerouteWasLocal) {
            if (localRerouteInitiatedByNodeClient) {
                return this.indexingPressure.markPrimaryOperationLocalToCoordinatingNodeStarted(this.primaryOperationSize(request));
            }
            return () -> {};
        }
        return this.indexingPressure.markPrimaryOperationStarted(this.primaryOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected long primaryOperationSize(Request request) {
        return 0L;
    }

    @Override
    protected Releasable checkReplicaLimits(ReplicaRequest request) {
        return this.indexingPressure.markReplicaOperationStarted(this.replicaOperationSize(request), this.force((ReplicatedWriteRequest<?>)request));
    }

    protected long replicaOperationSize(ReplicaRequest request) {
        return 0L;
    }

    protected static Translog.Location syncOperationResultOrThrow(Engine.Result operationResult, Translog.Location currentLocation) throws Exception {
        if (operationResult.getFailure() != null) {
            Exception failure = operationResult.getFailure();
            assert (failure instanceof MapperParsingException) : "expected mapper parsing failures. got " + failure;
            throw failure;
        }
        Translog.Location location = TransportWriteAction.locationToSync(currentLocation, operationResult.getTranslogLocation());
        return location;
    }

    public static Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    @Override
    protected ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy() {
        return new WriteActionReplicasProxy();
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> listener) {
        String executor = this.executorFunction.apply(primary);
        this.threadPool.executor(executor).execute(new ActionRunnable<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>>(listener, (ReplicatedWriteRequest)request, primary){
            final /* synthetic */ ReplicatedWriteRequest val$request;
            final /* synthetic */ IndexShard val$primary;
            {
                this.val$request = replicatedWriteRequest;
                this.val$primary = indexShard;
                super(listener);
            }

            @Override
            protected void doRun() {
                TransportWriteAction.this.dispatchedShardOperationOnPrimary(this.val$request, this.val$primary, this.listener);
            }

            @Override
            public boolean isForceExecution() {
                return TransportWriteAction.this.force(this.val$request);
            }
        });
    }

    protected abstract void dispatchedShardOperationOnPrimary(Request var1, IndexShard var2, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> var3);

    @Override
    protected void shardOperationOnReplica(final ReplicaRequest request, final IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        this.threadPool.executor(this.executorFunction.apply(replica)).execute(new ActionRunnable<TransportReplicationAction.ReplicaResult>(listener){

            @Override
            protected void doRun() {
                TransportWriteAction.this.dispatchedShardOperationOnReplica(request, replica, this.listener);
            }

            @Override
            public boolean isForceExecution() {
                return true;
            }
        });
    }

    protected abstract void dispatchedShardOperationOnReplica(ReplicaRequest var1, IndexShard var2, ActionListener<TransportReplicationAction.ReplicaResult> var3);

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    class WriteActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        WriteActionReplicasProxy() {
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            if (!TransportActions.isShardNotAvailableException(exception)) {
                TransportWriteAction.this.logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)replica.shardId(), (Object)message), (Throwable)exception);
            }
            TransportWriteAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, true, message, exception, listener);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportWriteAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }

    static final class AsyncAfterWriteAction {
        private final Translog.Location location;
        private final boolean waitUntilRefresh;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final IndexShard indexShard;
        private final WriteRequest<?> request;
        private final Logger logger;

        AsyncAfterWriteAction(IndexShard indexShard, WriteRequest<?> request, @Nullable Translog.Location location, RespondingWriteResult respond, Logger logger) {
            this.indexShard = indexShard;
            this.request = request;
            boolean waitUntilRefresh = false;
            switch (request.getRefreshPolicy()) {
                case IMMEDIATE: {
                    indexShard.refresh("refresh_flag_index");
                    this.refreshed.set(true);
                    break;
                }
                case WAIT_UNTIL: {
                    if (location == null) break;
                    waitUntilRefresh = true;
                    this.pendingOps.incrementAndGet();
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown refresh policy: " + request.getRefreshPolicy());
                }
            }
            this.waitUntilRefresh = waitUntilRefresh;
            this.respond = respond;
            this.location = location;
            this.sync = indexShard.getTranslogDurability() == Translog.Durability.REQUEST && location != null;
            if (this.sync) {
                this.pendingOps.incrementAndGet();
            }
            this.logger = logger;
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOpts was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        void run() {
            this.indexShard.afterWriteOperation();
            this.maybeFinish();
            if (this.waitUntilRefresh) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.addRefreshListener(this.location, forcedRefresh -> {
                    if (forcedRefresh.booleanValue()) {
                        this.logger.warn("block until refresh ran out of slots and forced a refresh: [{}]", this.request);
                    }
                    this.refreshed.set((boolean)forcedRefresh);
                    this.maybeFinish();
                });
            }
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.sync(this.location, ex -> {
                    this.syncFailure.set((Exception)ex);
                    this.maybeFinish();
                });
            }
        }
    }

    static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    public static class WriteReplicaResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>>
    extends TransportReplicationAction.ReplicaResult {
        public final Translog.Location location;
        private final ReplicaRequest request;
        private final IndexShard replica;
        private final Logger logger;

        public WriteReplicaResult(ReplicaRequest request, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard replica, Logger logger) {
            super(operationFailure);
            this.location = location;
            this.request = request;
            this.replica = replica;
            this.logger = logger;
        }

        @Override
        public void runPostReplicaActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.replica, (WriteRequest<?>)this.request, this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }, this.logger).run();
            }
        }
    }

    public static class WritePrimaryResult<ReplicaRequest extends ReplicatedWriteRequest<ReplicaRequest>, Response extends ReplicationResponse>
    extends TransportReplicationAction.PrimaryResult<ReplicaRequest, Response> {
        public final Translog.Location location;
        public final IndexShard primary;
        private final Logger logger;

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard primary, Logger logger) {
            super(request, finalResponse, operationFailure);
            this.location = location;
            this.primary = primary;
            this.logger = logger;
            assert (location == null || operationFailure == null) : "expected either failure to be null or translog location to be null, but found: [" + location + "] translog location and [" + operationFailure + "] failure";
        }

        @Override
        public void runPostReplicationActions(final ActionListener<Void> listener) {
            if (this.finalFailure != null) {
                listener.onFailure(this.finalFailure);
            } else {
                new AsyncAfterWriteAction(this.primary, (WriteRequest)((Object)this.replicaRequest), this.location, new RespondingWriteResult(){

                    @Override
                    public void onSuccess(boolean forcedRefresh) {
                        ((WriteResponse)((Object)finalResponseIfSuccessful)).setForcedRefresh(forcedRefresh);
                        listener.onResponse(null);
                    }

                    @Override
                    public void onFailure(Exception ex) {
                        listener.onFailure(ex);
                    }
                }, this.logger).run();
            }
        }
    }
}

