/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.apache.james.util.MDCBuilder;

public class ListCmdHandler
implements CommandHandler<POP3Session> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"LIST");
    private final MetricFactory metricFactory;

    @Inject
    public ListCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-list", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addContext("action", (Object)"LIST").addContext(MDCConstants.withSession(session)).addContext(MDCConstants.forRequest(request)), () -> this.list(session, request)));
    }

    private Response list(POP3Session session, Request request) {
        String parameters = request.getArgument();
        List uidList = (List)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
        List deletedUidList = (List)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
        if (session.getHandlerState() == 2) {
            POP3Response response = null;
            if (parameters == null) {
                long size = 0L;
                int count = 0;
                ArrayList<MessageMetaData> validResults = new ArrayList<MessageMetaData>();
                if (!uidList.isEmpty()) {
                    for (MessageMetaData data : uidList) {
                        if (deletedUidList.contains(data.getUid())) continue;
                        size += data.getSize();
                        ++count;
                        validResults.add(data);
                    }
                }
                StringBuilder responseBuffer = new StringBuilder(32).append(count).append(" ").append(size);
                response = new POP3Response("+OK", responseBuffer.toString());
                count = 0;
                for (int i = 0; i < validResults.size(); ++i) {
                    responseBuffer = new StringBuilder(16).append(i + 1).append(" ").append(((MessageMetaData)validResults.get(i)).getSize());
                    response.appendLine(responseBuffer.toString());
                }
                response.appendLine(".");
            } else {
                int num = 0;
                try {
                    num = Integer.parseInt(parameters);
                    MessageMetaData data = MessageMetaDataUtils.getMetaData(session, num);
                    if (data == null) {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        return new POP3Response("-ERR", responseBuffer.toString());
                    }
                    if (!deletedUidList.contains(data.getUid())) {
                        StringBuilder responseBuffer = new StringBuilder(64).append(num).append(" ").append(data.getSize());
                        response = new POP3Response("+OK", responseBuffer.toString());
                    } else {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                    }
                }
                catch (IndexOutOfBoundsException npe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (NumberFormatException nfe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append(parameters).append(" is not a valid number");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            }
            return response;
        }
        return POP3Response.ERR;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

