/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.backends.rabbitmq.ReactorRabbitMQChannelPool;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.GroupAlreadyRegistered;
import org.apache.james.events.GroupRegistration;
import org.apache.james.events.GroupRegistrationNotFound;
import org.apache.james.events.ListenerExecutor;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.Registration;
import org.apache.james.events.RetryBackoffConfiguration;
import reactor.rabbitmq.Sender;

class GroupRegistrationHandler {
    private final NamingStrategy namingStrategy;
    private final Map<Group, GroupRegistration> groupRegistrations;
    private final EventSerializer eventSerializer;
    private final ReactorRabbitMQChannelPool channelPool;
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private final RetryBackoffConfiguration retryBackoff;
    private final EventDeadLetters eventDeadLetters;
    private final ListenerExecutor listenerExecutor;

    GroupRegistrationHandler(NamingStrategy namingStrategy, EventSerializer eventSerializer, ReactorRabbitMQChannelPool channelPool, Sender sender, ReceiverProvider receiverProvider, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters, ListenerExecutor listenerExecutor) {
        this.namingStrategy = namingStrategy;
        this.eventSerializer = eventSerializer;
        this.channelPool = channelPool;
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.retryBackoff = retryBackoff;
        this.eventDeadLetters = eventDeadLetters;
        this.listenerExecutor = listenerExecutor;
        this.groupRegistrations = new ConcurrentHashMap<Group, GroupRegistration>();
    }

    GroupRegistration retrieveGroupRegistration(Group group) {
        return Optional.ofNullable(this.groupRegistrations.get(group)).orElseThrow(() -> new GroupRegistrationNotFound(group));
    }

    void stop() {
        this.groupRegistrations.values().forEach(GroupRegistration::unregister);
    }

    Registration register(EventListener.ReactiveEventListener listener, Group group) {
        return this.groupRegistrations.compute(group, (groupToRegister, oldGroupRegistration) -> {
            if (oldGroupRegistration != null) {
                throw new GroupAlreadyRegistered(group);
            }
            return this.newGroupRegistration(listener, (Group)groupToRegister);
        }).start();
    }

    private GroupRegistration newGroupRegistration(EventListener.ReactiveEventListener listener, Group group) {
        return new GroupRegistration(this.namingStrategy, this.channelPool, this.sender, this.receiverProvider, this.eventSerializer, listener, group, this.retryBackoff, this.eventDeadLetters, () -> this.groupRegistrations.remove(group), this.listenerExecutor);
    }
}

