/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.export.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.export.api.BlobExportMechanism;
import org.apache.james.blob.export.api.ExportedFileNamesGenerator;
import org.apache.james.blob.export.api.FileExtension;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;

public class LocalFileBlobExportMechanism
implements BlobExportMechanism {
    private static final String SUBJECT = "Some content had had just been exported";
    static final String CORRESPONDING_FILE_HEADER = "corresponding-file";
    private final MailetContext mailetContext;
    private final BlobStore blobStore;
    private final FileSystem fileSystem;
    private final DNSService dnsService;
    private final Configuration configuration;

    @Inject
    @VisibleForTesting
    public LocalFileBlobExportMechanism(MailetContext mailetContext, BlobStore blobStore, FileSystem fileSystem, DNSService dnsService, Configuration configuration) {
        this.mailetContext = mailetContext;
        this.blobStore = blobStore;
        this.fileSystem = fileSystem;
        this.dnsService = dnsService;
        this.configuration = configuration;
    }

    public BlobExportMechanism.ShareeStage blobId(BlobId blobId) {
        return mailAddress -> explanation -> fileCustomPrefix -> fileExtension -> () -> {
            String fileUrl = this.copyBlobToFile(blobId, fileCustomPrefix, fileExtension);
            this.sendMail(mailAddress, fileUrl, explanation);
        };
    }

    private String copyBlobToFile(BlobId blobId, Optional<String> fileCustomPrefix, Optional<FileExtension> fileExtension) {
        try {
            File exportingDirectory = this.fileSystem.getFile(this.configuration.exportDirectory);
            FileUtils.forceMkdir((File)exportingDirectory);
            String fileName = ExportedFileNamesGenerator.generateFileName(fileCustomPrefix, (BlobId)blobId, fileExtension);
            String fileURL = this.configuration.exportDirectory + "/" + fileName;
            File file = this.fileSystem.getFile(fileURL);
            FileUtils.copyToFile((InputStream)this.blobStore.read(this.blobStore.getDefaultBucketName(), blobId, BlobStore.StoragePolicy.LOW_COST), (File)file);
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new BlobExportMechanism.BlobExportException("Error while copying blob to file", (Throwable)e);
        }
    }

    private void sendMail(MailAddress mailAddress, String fileUrl, String explanation) {
        try {
            MimeMessageBuilder mimeMessage = MimeMessageBuilder.mimeMessageBuilder().addHeader(CORRESPONDING_FILE_HEADER, fileUrl).addFrom(this.mailetContext.getPostmaster().asString()).addToRecipient(mailAddress.asString()).setSubject(SUBJECT).setText(this.computeMessage(explanation, fileUrl));
            MailImpl mail = MailImpl.builder().name(MailImpl.getId()).sender(this.mailetContext.getPostmaster()).addRecipient(mailAddress).mimeMessage(mimeMessage).build();
            this.mailetContext.sendMail((Mail)mail);
        }
        catch (Exception e) {
            throw new BlobExportMechanism.BlobExportException("Error while sending email", (Throwable)e);
        }
    }

    private String computeMessage(String explanationText, String fileUrl) throws UnknownHostException {
        String hostname = this.dnsService.getLocalHost().getHostName();
        return explanationText + "\n\nThe content of this blob can be read directly on James host filesystem (" + hostname + ") in this file: " + fileUrl;
    }

    public static class Configuration {
        private static final String DIRECTORY_LOCATION_PROPERTY = "blob.export.localFile.directory";
        private static final String DEFAULT_DIRECTORY_LOCATION = "file://var/blobExporting";
        public static final Configuration DEFAULT_CONFIGURATION = new Configuration("file://var/blobExporting");
        private final String exportDirectory;

        public static Optional<Configuration> from(org.apache.commons.configuration2.Configuration propertiesConfiguration) {
            String exportDirectory = propertiesConfiguration.getString(DIRECTORY_LOCATION_PROPERTY, null);
            return Optional.ofNullable(exportDirectory).map(Configuration::new);
        }

        @VisibleForTesting
        Configuration(String exportDirectory) {
            Preconditions.checkNotNull((Object)exportDirectory);
            this.exportDirectory = exportDirectory;
        }

        public String getExportDirectory() {
            return this.exportDirectory;
        }

        public final boolean equals(Object o) {
            if (o instanceof Configuration) {
                Configuration that = (Configuration)o;
                return Objects.equals(this.exportDirectory, that.exportDirectory);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.exportDirectory);
        }
    }
}

