/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.utils.quotas;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.jmap.core.UnsignedInt$;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.Quota$;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.QuotaId$;
import org.apache.james.jmap.mail.QuotaRoot;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.Quotas$;
import org.apache.james.jmap.mail.Quotas$Message$;
import org.apache.james.jmap.mail.Quotas$Storage$;
import org.apache.james.jmap.mail.Value;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.quota.QuotaManager;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\u0004\b\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006I\u0001!\t!\n\u0005\u0006e\u0001!\ta\r\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003c\u0001A\u0011BA\u001a\u0005-\tVo\u001c;b%\u0016\fG-\u001a:\u000b\u0005!I\u0011AB9v_R\f7O\u0003\u0002\u000b\u0017\u0005)Q\u000f^5mg*\u0011A\"D\u0001\u0005U6\f\u0007O\u0003\u0002\u000f\u001f\u0005)!.Y7fg*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\ti\"%D\u0001\u001f\u0015\ty\u0002%A\u0003rk>$\u0018M\u0003\u0002\"\u001b\u00059Q.Y5mE>D\u0018BA\u0012\u001f\u00051\tVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011a\u0002\u0005\u00067\t\u0001\r\u0001\b\u0015\u0003\u0005)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\r%t'.Z2u\u0015\u0005y\u0013!\u00026bm\u0006D\u0018BA\u0019-\u0005\u0019IeN[3di\u0006q!/\u001a;sS\u00164X-U;pi\u0006\u001cHC\u0001\u001bF!\r)ThP\u0007\u0002m)\u0011q\u0007O\u0001\naV\u0014G.[:iKJT!\u0001G\u001d\u000b\u0005iZ\u0014\u0001B2pe\u0016T\u0011\u0001P\u0001\be\u0016\f7\r^8s\u0013\tqdGA\u0003T\u001b>tw\u000e\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u0017\u0005!Q.Y5m\u0013\t!\u0015I\u0001\u0004Rk>$\u0018m\u001d\u0005\u0006\r\u000e\u0001\raR\u0001\ncV|G/\u0019*p_R\u0004\"\u0001\u0011%\n\u0005%\u000b%!C)v_R\f'k\\8uQ\r\u00191\n\u0016\t\u0004-1s\u0015BA'\u0018\u0005\u0019!\bN]8xgB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bI\u0001\nKb\u001cW\r\u001d;j_:L!a\u0015)\u0003!5\u000b\u0017\u000e\u001c2pq\u0016C8-\u001a9uS>t\u0017\u0007\u0002\u0010VAf\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u0018\u001b\u0005I&B\u0001.\u0014\u0003\u0019a$o\\8u}%\u0011AlF\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]/E*1%Y3uMV\u0011!mY\u000b\u0002+\u0012)Am\u0005b\u0001S\n\tA+\u0003\u0002gO\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!\u0001[\f\u0002\rQD'o\\<t#\tQW\u000e\u0005\u0002\u0017W&\u0011An\u0006\u0002\b\u001d>$\b.\u001b8h!\tq\u0017O\u0004\u0002\u0017_&\u0011\u0001oF\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118OA\u0005UQJ|w/\u00192mK*\u0011\u0001oF\u0019\u0006GU4x\u000f\u001b\b\u0003-YL!\u0001[\f2\t\t2r\u0003\u001f\u0002\u0006g\u000e\fG.Y\u0019\u0003M9\u000bA\"];pi\u0006$vNV1mk\u0016,R\u0001`A\n\u0003K!2!`A\u0001!\t\u0001e0\u0003\u0002\u0000\u0003\n)a+\u00197vK\"1q\u0004\u0002a\u0001\u0003\u0007\u0001\u0002\"!\u0002\u0002\f\u0005=\u00111E\u0007\u0003\u0003\u000fQ1!!\u0003!\u0003\u0015iw\u000eZ3m\u0013\u0011\ti!a\u0002\u0003\u000bE+x\u000e^1\u0011\t\u0005E\u00111\u0003\u0007\u0001\t\u0019!GA1\u0001\u0002\u0016E\u0019!.a\u0006\u0011\r\u0005e\u0011qDA\b\u001b\t\tYBC\u0002 \u0003;Q!AO\u0007\n\t\u0005\u0005\u00121\u0004\u0002\u0010#V|G/\u0019'j[&$h+\u00197vKB!\u0011\u0011CA\u0013\t\u001d\t9\u0003\u0002b\u0001\u0003S\u0011\u0011!V\t\u0004U\u0006-\u0002\u0003CA\r\u0003[\t\u0019#a\u0004\n\t\u0005=\u00121\u0004\u0002\u0010#V|G/Y+tC\u001e,g+\u00197vK\u0006A\u0011m\u001d(v[\n,'\u000f\u0006\u0003\u00026\u0005}\u0003#\u0002\f\u00028\u0005m\u0012bAA\u001d/\t1q\n\u001d;j_:\u0004B!!\u0010\u0002Z9!\u0011qHA*\u001d\u0011\t\t%!\u0015\u000f\t\u0005\r\u0013q\n\b\u0005\u0003\u000b\niE\u0004\u0003\u0002H\u0005-cb\u0001-\u0002J%\t!#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AO\u0006\n\t\u0005U\u0013qK\u0001\f+:\u001c\u0018n\u001a8fI&sGO\u0003\u0002;\u0017%!\u00111LA/\u0005-)fn]5h]\u0016$\u0017J\u001c;\u000b\t\u0005U\u0013q\u000b\u0005\b\u0003C*\u0001\u0019AA2\u0003\u00151\u0018\r\\;fa\u0011\t)'!\u001b\u0011\r\u0005e\u0011qDA4!\u0011\t\t\"!\u001b\u0005\u0019\u0005-\u0014qLA\u0001\u0002\u0003\u0015\t!!\u001c\u0003\u0007}#\u0013'E\u0002k\u0003_\u00022AFA9\u0013\r\t\u0019h\u0006\u0002\u0004\u0003:L\b")
public class QuotaReader {
    private final QuotaManager quotaManager;

    public SMono<Quotas> retrieveQuotas(QuotaRoot quotaRoot) throws MailboxException {
        QuotaRoot quotaId = QuotaId$.MODULE$.fromQuotaRoot(quotaRoot);
        QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot.toModel());
        return SMono$.MODULE$.just((Object)new Quotas((Map<QuotaId, Quota>)Quotas$.MODULE$.from(quotaId, Quota$.MODULE$.from((Map<Quotas.Type, Value>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Quotas$Storage$.MODULE$), (Object)this.quotaToValue(quotas.getStorageQuota())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Quotas$Message$.MODULE$), (Object)this.quotaToValue(quotas.getMessageQuota()))})))))));
    }

    private <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> Value quotaToValue(org.apache.james.mailbox.model.Quota<T, U> quota) {
        return new Value(UnsignedInt$.MODULE$.liftOrThrow(quota.getUsed().asLong()), this.asNumber(quota.getLimit()));
    }

    private Option<Refined<Object, boolean.And<boolean.Not<numeric.Less<Object>>, boolean.Not<numeric.Greater<Object>>>>> asNumber(QuotaLimitValue<?> value) {
        return value.isUnlimited() ? None$.MODULE$ : new Some((Object)new Refined((Object)UnsignedInt$.MODULE$.liftOrThrow(value.asLong())));
    }

    @Inject
    public QuotaReader(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }
}

