/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.State;
import org.apache.james.jmap.core.State$;
import org.apache.james.jmap.json.IdentitySerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.Identity;
import org.apache.james.jmap.mail.Identity$;
import org.apache.james.jmap.mail.IdentityFactory;
import org.apache.james.jmap.mail.IdentityGetRequest;
import org.apache.james.jmap.mail.IdentityGetResponse;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\b\u0010\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011)\u0019!C\u0001a!A\u0011\b\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005;\u0001\t\u0015\r\u0011\"\u0001<\u0011!\u0011\u0005A!A!\u0002\u0013a\u0004\"B\"\u0001\t\u0003!\u0005b\u0002*\u0001\u0005\u0004%\te\u0015\u0005\u0007U\u0002\u0001\u000b\u0011\u0002+\t\u000f-\u0004!\u0019!C!Y\"1A\u0010\u0001Q\u0001\n5DQ! \u0001\u0005ByDq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002^\u0001!I!a\u0018\u0003#%#WM\u001c;jif<U\r^'fi\"|GM\u0003\u0002\u0011#\u00051Q.\u001a;i_\u0012T!AE\n\u0002\t)l\u0017\r\u001d\u0006\u0003)U\tQA[1nKNT!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u00042AI\u0012&\u001b\u0005y\u0011B\u0001\u0013\u0010\u0005aiU\r\u001e5pIJ+\u0017/^5sS:<\u0017iY2pk:$\u0018\n\u001a\t\u0003M%j\u0011a\n\u0006\u0003QE\tA!\\1jY&\u0011!f\n\u0002\u0013\u0013\u0012,g\u000e^5us\u001e+GOU3rk\u0016\u001cH/A\bjI\u0016tG/\u001b;z\r\u0006\u001cGo\u001c:z!\t1S&\u0003\u0002/O\ty\u0011\nZ3oi&$\u0018PR1di>\u0014\u00180A\u0007nKR\u0014\u0018n\u0019$bGR|'/_\u000b\u0002cA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0004CBL'B\u0001\u001c\u0014\u0003\u001diW\r\u001e:jGNL!\u0001O\u001a\u0003\u001b5+GO]5d\r\u0006\u001cGo\u001c:z\u00039iW\r\u001e:jG\u001a\u000b7\r^8ss\u0002\nqb]3tg&|gnU;qa2LWM]\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011q(E\u0001\u0007e>,H/Z:\n\u0005\u0005s$aD*fgNLwN\\*vaBd\u0017.\u001a:\u0002!M,7o]5p]N+\b\u000f\u001d7jKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003F\r\u001eC\u0005C\u0001\u0012\u0001\u0011\u0015Yc\u00011\u0001-\u0011\u0015yc\u00011\u00012\u0011\u0015Qd\u00011\u0001=Q\t1!\n\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u00061\u0011N\u001c6fGRT\u0011aT\u0001\u0006U\u00064\u0018\r_\u0005\u0003#2\u0013a!\u00138kK\u000e$\u0018AC7fi\"|GMT1nKV\tA\u000b\u0005\u0002VO:\u0011a\u000b\u001a\b\u0003/\nt!\u0001W1\u000f\u0005e\u0003gB\u0001.`\u001d\tYf,D\u0001]\u0015\ti\u0016$\u0001\u0004=e>|GOP\u0005\u00021%\u0011acF\u0005\u0003)UI!AE\n\n\u0005\r\f\u0012\u0001B2pe\u0016L!!\u001a4\u0002\u0015%sgo\\2bi&|gN\u0003\u0002d#%\u0011\u0001.\u001b\u0002\u000b\u001b\u0016$\bn\u001c3OC6,'BA3g\u0003-iW\r\u001e5pI:\u000bW.\u001a\u0011\u0002)I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3t+\u0005i\u0007c\u00018sk:\u0011q\u000e\u001d\t\u00037vI!!]\u000f\u0002\rA\u0013X\rZ3g\u0013\t\u0019HOA\u0002TKRT!!]\u000f\u0011\u0005YLhB\u0001,x\u0013\tAh-\u0001\u000bDCB\f'-\u001b7jifLE-\u001a8uS\u001aLWM]\u0005\u0003un\u0014AcQ1qC\nLG.\u001b;z\u0013\u0012,g\u000e^5gS\u0016\u0014(B\u0001=g\u0003U\u0011X-];je\u0016$7)\u00199bE&d\u0017\u000e^5fg\u0002\n\u0011\u0002Z8Qe>\u001cWm]:\u0015\u0013}\fI\"!\b\u0002\"\u0005E\u0002CBA\u0001\u0003\u001f\t\u0019\"\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%\u0001XO\u00197jg\",'OC\u0002\u001f\u0003\u0013Q1aYA\u0006\u0015\t\ti!A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005E\u00111\u0001\u0002\u0006'6{gn\u001c\t\u0004E\u0005U\u0011bAA\f\u001f\t)\u0012J\u001c<pG\u0006$\u0018n\u001c8XSRD7i\u001c8uKb$\bBBA\u000e\u0017\u0001\u0007Q.\u0001\u0007dCB\f'-\u001b7ji&,7\u000fC\u0004\u0002 -\u0001\r!a\u0005\u0002\u0015%tgo\\2bi&|g\u000eC\u0004\u0002$-\u0001\r!!\n\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,M\tq!\\1jY\n|\u00070\u0003\u0003\u00020\u0005%\"AD'bS2\u0014w\u000e_*fgNLwN\u001c\u0005\u0007\u0003gY\u0001\u0019A\u0013\u0002\u000fI,\u0017/^3ti\u0006Qq-\u001a;SKF,Xm\u001d;\u0015\r\u0005e\u0012\u0011KA*!\u001d\tY$!\u0012\u0002L\u0015rA!!\u0010\u0002B9\u00191,a\u0010\n\u0003yI1!a\u0011\u001e\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0012\u0002J\t1Q)\u001b;iKJT1!a\u0011\u001e!\u0011\tY$!\u0014\n\t\u0005=\u0013\u0011\n\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBA\u0012\u0019\u0001\u0007\u0011Q\u0005\u0005\b\u0003?a\u0001\u0019AA+!\u0011\t9&!\u0017\u000e\u0003\u0019L1!a\u0017g\u0005)IeN^8dCRLwN\\\u0001\u000eO\u0016$\u0018\nZ3oi&$\u0018.Z:\u0015\r\u0005\u0005\u0014\u0011NA6!\u0019\t\t!a\u0004\u0002dA\u0019a%!\u001a\n\u0007\u0005\u001dtEA\nJI\u0016tG/\u001b;z\u000f\u0016$(+Z:q_:\u001cX\r\u0003\u0004\u000245\u0001\r!\n\u0005\b\u0003Gi\u0001\u0019AA\u0013\u0001")
public class IdentityGetMethod
implements MethodRequiringAccountId<IdentityGetRequest> {
    private final IdentityFactory identityFactory;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, IdentityGetRequest request) {
        SMono sMono;
        Properties requestedProperties = (Properties)request.properties().getOrElse((Function0 & Serializable)() -> Identity$.MODULE$.allProperties());
        Properties properties = requestedProperties.$minus$minus(Identity$.MODULE$.allProperties());
        if (properties.isEmpty()) {
            sMono = this.getIdentities(request, mailboxSession).subscribeOn(Schedulers.elastic()).map((Function1 & Serializable)identityGetResponse -> new Invocation(this.methodName(), (JsObject)IdentitySerializer$.MODULE$.serialize((IdentityGetResponse)identityGetResponse, requestedProperties.$plus$plus(Identity$.MODULE$.idProperty())).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()));
        } else if (properties != null) {
            Properties properties2 = properties;
            sMono = SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, new StringBuilder(41).append("The following properties [").append(properties2.format()).append("] do not exist.").toString(), invocation.invocation().methodCallId()));
        } else {
            throw new MatchError((Object)properties);
        }
        return sMono.map((Function1 & Serializable)x$1 -> new InvocationWithContext((Invocation)x$1, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, IdentityGetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Right right;
        JsResult<IdentityGetRequest> jsResult = IdentitySerializer$.MODULE$.deserialize((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            IdentityGetRequest request = (IdentityGetRequest)jsSuccess.value();
            right = package$.MODULE$.Right().apply((Object)request);
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            right = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        } else {
            throw new MatchError(jsResult);
        }
        return right;
    }

    private SMono<IdentityGetResponse> getIdentities(IdentityGetRequest request, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromCallable(() -> $this.identityFactory.listIdentities(mailboxSession)).map((Function1 & Serializable)identities -> {
            AccountId x$1 = request.accountId();
            List x$2 = identities;
            State x$3 = State$.MODULE$.INSTANCE();
            return new IdentityGetResponse(x$1, x$3, (List<Identity>)x$2);
        });
    }

    @Inject
    public IdentityGetMethod(IdentityFactory identityFactory, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.identityFactory = identityFactory;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Identity/get")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.EMAIL_SUBMISSION())}));
        Statics.releaseFence();
    }
}

