/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Joiner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.james.core.Username;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.Service;
import spark.Spark;
import spark.utils.StringUtils;

@Api(tags={"SieveScript"})
@Path(value="/sieve")
public class SieveScriptRoutes
implements Routes {
    public static final String ROOT_PATH = "/sieve";
    public static final String SCRIPTS = "scripts";
    private static final String USER_NAME = "userName";
    private static final String SCRIPT_NAME = "scriptName";
    private static final String ACTIVATE_PARAMS = "activate";
    private static final String USER_SCRIPT_PATH = Joiner.on((String)"/").join((Object)"/sieve", (Object)":userName", new Object[]{"scripts", ":scriptName"});
    private final SieveRepository sieveRepository;
    private final UsersRepository usersRepository;

    @Inject
    public SieveScriptRoutes(SieveRepository sieveRepository, UsersRepository usersRepository) {
        this.sieveRepository = sieveRepository;
        this.usersRepository = usersRepository;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        this.defineAddActiveSieveScript(service);
    }

    @PUT
    @ApiOperation(value="Upload a new Sieve Script")
    @Path(value="/sieve/{userName}/scripts/{scriptName}")
    @ApiResponses(value={@ApiResponse(code=204, message="OK"), @ApiResponse(code=400, message="Invalid username"), @ApiResponse(code=400, message="Invalid Sieve script name"), @ApiResponse(code=400, message="Empty script is not accepted"), @ApiResponse(code=404, message="User not found")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", required=true, paramType="path", dataType="String", example="/sieve/userNameA/scripts/scriptName1", value="Username"), @ApiImplicitParam(name="scriptName", required=true, paramType="path", dataType="String", example="/sieve/userNameA/scripts/scriptName1", value="Script name"), @ApiImplicitParam(required=false, paramType="query parameter", dataType="Boolean", defaultValue="False", example="?activate=true", value="If present, automatically activating the script.")})
    public void defineAddActiveSieveScript(Service service) {
        service.put(USER_SCRIPT_PATH, this::addActiveSieveScript);
    }

    private HaltException addActiveSieveScript(Request request, Response response) throws UsersRepositoryException, QuotaExceededException, StorageException, ScriptNotFoundException {
        Username username = this.extractUser(request);
        ScriptName script = this.extractScriptName(request);
        boolean isActivated = this.isActivated(request.queryParams(ACTIVATE_PARAMS));
        this.sieveRepository.putScript(username, script, this.extractSieveScriptFromRequest(request));
        if (isActivated) {
            this.sieveRepository.setActive(username, script);
        }
        return Spark.halt((int)204);
    }

    private Username extractUser(Request request) throws UsersRepositoryException {
        Username userName = Optional.ofNullable(request.params(USER_NAME)).map(String::trim).filter(StringUtils::isNotEmpty).map(Username::of).orElseThrow(() -> this.throw400withInvalidArgument("Invalid username"));
        if (!this.usersRepository.contains(userName)) {
            this.throw404("User not found");
        }
        return userName;
    }

    private ScriptName extractScriptName(Request request) {
        return Optional.ofNullable(request.params(SCRIPT_NAME)).map(String::trim).filter(StringUtils::isNotEmpty).map(ScriptName::new).orElseThrow(() -> this.throw400withInvalidArgument("Invalid Sieve script name"));
    }

    private ScriptContent extractSieveScriptFromRequest(Request request) {
        return new ScriptContent(request.body());
    }

    private boolean isActivated(String activateParam) {
        return Optional.ofNullable(activateParam).map(String::trim).map(this::parseActivateParam).orElse(false);
    }

    private boolean parseActivateParam(String activateParam) {
        if (activateParam.equalsIgnoreCase(Boolean.TRUE.toString()) || activateParam.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return Boolean.parseBoolean(activateParam);
        }
        throw this.throw400withInvalidArgument("Invalid activate query parameter");
    }

    private HaltException throw400withInvalidArgument(String message) {
        throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(message).haltError();
    }

    private HaltException throw404(String message) {
        throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message(message).haltError();
    }
}

