/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.james.core.Domain;
import org.apache.james.domainlist.api.AutoDetectedDomainRemovalException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.DomainAliasResponse;
import org.apache.james.webadmin.service.DomainAliasService;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

@Api(tags={"Domains"})
@Path(value="/domains")
@Produces(value={"application/json"})
public class DomainsRoutes
implements Routes {
    public static final String DOMAINS = "/domains";
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainsRoutes.class);
    private static final String DOMAIN_NAME = ":domainName";
    private static final String SOURCE_DOMAIN = ":sourceDomain";
    private static final String DESTINATION_DOMAIN = ":destinationDomain";
    private static final String SPECIFIC_DOMAIN = "/domains/:domainName";
    private static final String ALIASES = "aliases";
    private static final String DOMAIN_ALIASES = "/domains/:domainName/aliases";
    private static final String SPECIFIC_ALIAS = "/domains/:destinationDomain/aliases/:sourceDomain";
    private final DomainList domainList;
    private final DomainAliasService domainAliasService;
    private final JsonTransformer jsonTransformer;
    private Service service;

    @Inject
    DomainsRoutes(DomainList domainList, DomainAliasService domainAliasService, JsonTransformer jsonTransformer) {
        this.domainList = domainList;
        this.domainAliasService = domainAliasService;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return DOMAINS;
    }

    public void define(Service service) {
        this.service = service;
        this.defineGetDomains();
        this.defineDomainExists();
        this.defineAddDomain();
        this.defineDeleteDomain();
        this.defineListAliases(service);
        this.defineAddAlias(service);
        this.defineRemoveAlias(service);
    }

    @DELETE
    @Path(value="/{domainName}")
    @ApiOperation(value="Deleting a domain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="domainName", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. Domain is removed."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDeleteDomain() {
        this.service.delete(SPECIFIC_DOMAIN, this::removeDomain);
    }

    @PUT
    @Path(value="/{domainName}")
    @ApiOperation(value="Creating new domain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="domainName", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK. New domain is created."), @ApiResponse(code=400, message="Invalid request for domain creation"), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineAddDomain() {
        this.service.put(SPECIFIC_DOMAIN, this::addDomain);
    }

    @GET
    @Path(value="/{domainName}")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="domainName", paramType="path")})
    @ApiOperation(value="Testing existence of a domain.")
    @ApiResponses(value={@ApiResponse(code=204, message="The domain exists", response=String.class), @ApiResponse(code=404, message="The domain does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineDomainExists() {
        this.service.get(SPECIFIC_DOMAIN, this::exists);
    }

    @GET
    @ApiOperation(value="Getting all domains")
    @ApiResponses(value={@ApiResponse(code=204, message="OK", response=List.class), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineGetDomains() {
        this.service.get(DOMAINS, (request, response) -> this.domainList.getDomains().stream().map(Domain::name).collect(Collectors.toList()), (ResponseTransformer)this.jsonTransformer);
    }

    @GET
    @Path(value="/{domainName}/aliases")
    @ApiOperation(value="Getting all aliases for a domain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="domainName", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=List.class), @ApiResponse(code=404, message="The domain does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineListAliases(Service service) {
        service.get(DOMAIN_ALIASES, this::listDomainAliases, (ResponseTransformer)this.jsonTransformer);
    }

    @DELETE
    @Path(value="/{destinationDomain}/aliases/{sourceDomain}")
    @ApiOperation(value="Remove an alias for a specific domain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="sourceDomain", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="destinationDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK", response=List.class), @ApiResponse(code=404, message="The domain does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineRemoveAlias(Service service) {
        service.delete(SPECIFIC_ALIAS, this::removeDomainAlias, (ResponseTransformer)this.jsonTransformer);
    }

    @PUT
    @Path(value="/{destinationDomain}/aliases/{sourceDomain}")
    @ApiOperation(value="Add an alias for a specific domain")
    @ApiImplicitParams(value={@ApiImplicitParam(required=true, dataType="string", name="sourceDomain", paramType="path"), @ApiImplicitParam(required=true, dataType="string", name="destinationDomain", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=204, message="OK", response=List.class), @ApiResponse(code=404, message="The domain does not exist."), @ApiResponse(code=500, message="Internal server error - Something went bad on the server side.")})
    public void defineAddAlias(Service service) {
        service.put(SPECIFIC_ALIAS, this::addDomainAlias, (ResponseTransformer)this.jsonTransformer);
    }

    private String removeDomain(Request request, Response response) throws RecipientRewriteTableException {
        try {
            Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
            this.domainList.removeDomain(domain);
            this.domainAliasService.removeCorrespondingDomainAliases(domain);
        }
        catch (AutoDetectedDomainRemovalException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Can not remove domain").cause((Exception)((Object)e)).haltError();
        }
        catch (DomainListException e) {
            LOGGER.info("{} did not exists", (Object)request.params(DOMAIN_NAME));
        }
        return Responses.returnNoContent((Response)response);
    }

    private String addDomain(Request request, Response response) {
        Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
        try {
            this.domainList.addDomain(domain);
            return Responses.returnNoContent((Response)response);
        }
        catch (DomainListException e) {
            LOGGER.info("{} already exists", (Object)domain);
            throw ErrorResponder.builder().statusCode(204).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("%s already exists", new Object[]{domain.name()}).cause((Exception)((Object)e)).haltError();
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Invalid request for domain creation");
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for domain creation %s", new Object[]{domain.name()}).cause((Exception)e).haltError();
        }
    }

    private Domain checkValidDomain(String domainName) {
        String urlDecodedDomainName = this.urlDecodeDomain(domainName);
        try {
            return Domain.of((String)urlDecodedDomainName);
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for domain creation %s", new Object[]{urlDecodedDomainName}).cause((Exception)e).haltError();
        }
    }

    private String urlDecodeDomain(String domainName) {
        try {
            return URLDecoder.decode(domainName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid request for domain creation %s unable to url decode some characters", new Object[]{domainName}).cause(e).haltError();
        }
    }

    private String exists(Request request, Response response) throws DomainListException {
        Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
        if (!this.domainList.containsDomain(domain)) {
            throw this.domainNotFound(domain);
        }
        return Responses.returnNoContent((Response)response);
    }

    private ImmutableSet<DomainAliasResponse> listDomainAliases(Request request, Response response) throws DomainListException, RecipientRewriteTableException {
        Domain domain = this.checkValidDomain(request.params(DOMAIN_NAME));
        if (!this.domainAliasService.hasAliases(domain)) {
            throw this.domainHasNoAliases(domain);
        }
        return this.domainAliasService.listDomainAliases(domain);
    }

    private String addDomainAlias(Request request, Response response) throws DomainListException, RecipientRewriteTableException {
        Domain sourceDomain = this.checkValidDomain(request.params(SOURCE_DOMAIN));
        Domain destinationDomain = this.checkValidDomain(request.params(DESTINATION_DOMAIN));
        try {
            this.domainAliasService.addDomainAlias(sourceDomain, destinationDomain);
            return Responses.returnNoContent((Response)response);
        }
        catch (DomainAliasService.DomainNotFound e) {
            throw this.domainNotFound(e.getDomain());
        }
        catch (SameSourceAndDestinationException e) {
            throw this.sameSourceAndDestination(sourceDomain);
        }
    }

    private String removeDomainAlias(Request request, Response response) throws DomainListException, RecipientRewriteTableException {
        Domain sourceDomain = this.checkValidDomain(request.params(SOURCE_DOMAIN));
        Domain destinationDomain = this.checkValidDomain(request.params(DESTINATION_DOMAIN));
        try {
            this.domainAliasService.removeDomainAlias(sourceDomain, destinationDomain);
            return Responses.returnNoContent((Response)response);
        }
        catch (DomainAliasService.DomainNotFound e) {
            throw this.domainNotFound(e.getDomain());
        }
        catch (SameSourceAndDestinationException e) {
            throw this.sameSourceAndDestination(sourceDomain);
        }
    }

    private HaltException domainNotFound(Domain domain) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The domain list does not contain: %s", new Object[]{domain.name()}).haltError();
    }

    private HaltException domainHasNoAliases(Domain domain) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The following domain is not in the domain list and has no registered local aliases: %s", new Object[]{domain.name()}).haltError();
    }

    private HaltException sameSourceAndDestination(Domain sameDomain) {
        return ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Source domain and destination domain can not have same value(%s)", new Object[]{sameDomain.name()}).haltError();
    }
}

