/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.objectstorage;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.io.FileNotFoundException;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreDAO;
import org.apache.james.modules.mailbox.ConfigurationComponent;
import org.apache.james.modules.objectstorage.S3BlobStoreConfigurationReader;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;

public class S3BlobStoreModule
extends AbstractModule {
    @Provides
    @Singleton
    private S3BlobStoreConfiguration getObjectStorageConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfigurations(ConfigurationComponent.NAMES);
            return S3BlobStoreConfigurationReader.from(configuration);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("blob configuration was not found");
        }
    }

    @ProvidesIntoSet
    InitializationOperation startS3BlobStoreDAO(S3BlobStoreDAO s3BlobStoreDAO) {
        return InitilizationOperationBuilder.forClass(S3BlobStoreDAO.class).init(() -> ((S3BlobStoreDAO)s3BlobStoreDAO).start());
    }
}

