/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota;

import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;

public interface QuotaManager {
    public Quota<QuotaCountLimit, QuotaCountUsage> getMessageQuota(QuotaRoot var1) throws MailboxException;

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(QuotaRoot var1) throws MailboxException;

    public Quotas getQuotas(QuotaRoot var1) throws MailboxException;

    public static class Quotas {
        private final Quota<QuotaCountLimit, QuotaCountUsage> messageQuota;
        private final Quota<QuotaSizeLimit, QuotaSizeUsage> storageQuota;

        public Quotas(Quota<QuotaCountLimit, QuotaCountUsage> messageQuota, Quota<QuotaSizeLimit, QuotaSizeUsage> storageQuota) {
            this.messageQuota = messageQuota;
            this.storageQuota = storageQuota;
        }

        public Quota<QuotaCountLimit, QuotaCountUsage> getMessageQuota() {
            return this.messageQuota;
        }

        public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota() {
            return this.storageQuota;
        }
    }
}

