/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.james.mailbox.model.MailboxId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxCounters {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxCounters.class);
    private final MailboxId mailboxId;
    private final long count;
    private final long unseen;

    public static Builder.RequireMailboxId builder() {
        return mailboxId -> count -> unseen -> new Builder.FinalStage(count, unseen, mailboxId);
    }

    private MailboxCounters(MailboxId mailboxId, long count, long unseen) {
        this.mailboxId = mailboxId;
        this.count = count;
        this.unseen = unseen;
    }

    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    public long getCount() {
        return this.count;
    }

    public long getUnseen() {
        return this.unseen;
    }

    public Sanitized sanitize() {
        if (!this.isValid()) {
            LOGGER.warn("Invalid mailbox counters for {} : {} / {}", new Object[]{this.mailboxId, this.unseen, this.count});
        }
        long sanitizedCount = Math.max(this.count, 0L);
        long positiveUnseen = Math.max(this.unseen, 0L);
        long sanitizedUnseen = Math.min(positiveUnseen, sanitizedCount);
        return Sanitized.of(this.mailboxId, sanitizedCount, sanitizedUnseen);
    }

    public boolean isValid() {
        return this.count >= 0L && this.unseen >= 0L && this.count >= this.unseen;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxCounters) {
            MailboxCounters that = (MailboxCounters)o;
            return Objects.equal((Object)this.count, (Object)that.count) && Objects.equal((Object)this.unseen, (Object)that.unseen) && Objects.equal((Object)this.mailboxId, (Object)that.mailboxId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.count, this.unseen, this.mailboxId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailboxId", (Object)this.mailboxId).add("count", this.count).add("unseen", this.unseen).toString();
    }

    public static class Sanitized
    extends MailboxCounters {
        static Sanitized of(MailboxId mailboxId, long count, long unseen) {
            Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"'count' need to be strictly positive");
            Preconditions.checkArgument((unseen >= 0L ? 1 : 0) != 0, (Object)"'count' need to be strictly positive");
            Preconditions.checkArgument((count >= unseen ? 1 : 0) != 0, (Object)"'unseen' cannot exceed 'count'");
            return new Sanitized(mailboxId, count, unseen);
        }

        private Sanitized(MailboxId mailboxId, long count, long unseen) {
            super(mailboxId, count, unseen);
        }
    }

    public static interface Builder {

        public static class FinalStage {
            private final long count;
            private final long unseen;
            private final MailboxId mailboxId;

            FinalStage(long count, long unseen, MailboxId mailboxId) {
                this.count = count;
                this.unseen = unseen;
                this.mailboxId = mailboxId;
            }

            public MailboxCounters build() {
                return new MailboxCounters(this.mailboxId, this.count, this.unseen);
            }
        }

        @FunctionalInterface
        public static interface RequireUnseen {
            public FinalStage unseen(long var1);
        }

        @FunctionalInterface
        public static interface RequireCount {
            public RequireUnseen count(long var1);
        }

        @FunctionalInterface
        public static interface RequireMailboxId {
            public RequireCount mailboxId(MailboxId var1);
        }
    }
}

