/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.james.mailbox.exception.BlobNotFoundException;
import org.apache.james.mailbox.model.BlobId;
import org.apache.james.mailbox.model.ContentType;

public class Blob {
    private final BlobId blobId;
    private final InputStreamSupplier payload;
    private final ContentType contentType;
    private final long size;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    Blob(BlobId blobId, InputStreamSupplier payload, ContentType contentType, long size) {
        this.blobId = blobId;
        this.payload = payload;
        this.contentType = contentType;
        this.size = size;
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public InputStream getStream() throws IOException {
        return this.payload.load();
    }

    public long getSize() {
        return this.size;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public final boolean equals(Object o) {
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            return Objects.equals(this.blobId, blob.blobId) && Objects.equals(this.contentType, blob.contentType);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.blobId, this.contentType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blobId", (Object)this.blobId).add("contentType", (Object)this.contentType).toString();
    }

    public static class Builder {
        private BlobId blobId;
        private InputStreamSupplier payload;
        private ContentType contentType;
        private Long size;

        private Builder() {
        }

        public Builder id(BlobId id) {
            this.blobId = id;
            return this;
        }

        public Builder payload(InputStreamSupplier payload) {
            this.payload = payload;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = ContentType.of(contentType);
            return this;
        }

        public Builder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Blob build() {
            Preconditions.checkState((this.blobId != null ? 1 : 0) != 0, (Object)"id can not be empty");
            Preconditions.checkState((this.payload != null ? 1 : 0) != 0, (Object)"payload can not be empty");
            Preconditions.checkState((this.contentType != null ? 1 : 0) != 0, (Object)"contentType can not be empty");
            Preconditions.checkState((this.size != null ? 1 : 0) != 0, (Object)"size can not be empty");
            return new Blob(this.blobId, this.payload, this.contentType, this.size);
        }
    }

    @FunctionalInterface
    public static interface InputStreamSupplier {
        public InputStream load() throws IOException, BlobNotFoundException;
    }
}

