/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.DeleteResult;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface MessageIdManager {
    default public Publisher<ComposedMessageIdWithMetaData> messageMetadata(MessageId id, MailboxSession session) {
        return this.messagesMetadata((Collection<MessageId>)ImmutableList.of((Object)id), session);
    }

    public Publisher<ComposedMessageIdWithMetaData> messagesMetadata(Collection<MessageId> var1, MailboxSession var2);

    public Set<MessageId> accessibleMessages(Collection<MessageId> var1, MailboxSession var2) throws MailboxException;

    public void setFlags(Flags var1, MessageManager.FlagsUpdateMode var2, MessageId var3, List<MailboxId> var4, MailboxSession var5) throws MailboxException;

    public List<MessageResult> getMessages(Collection<MessageId> var1, FetchGroup var2, MailboxSession var3) throws MailboxException;

    default public Publisher<MessageResult> getMessagesReactive(Collection<MessageId> messageIds, FetchGroup minimal, MailboxSession mailboxSession) {
        try {
            return Flux.fromIterable(this.getMessages(messageIds, minimal, mailboxSession));
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
    }

    public DeleteResult delete(MessageId var1, List<MailboxId> var2, MailboxSession var3) throws MailboxException;

    public DeleteResult delete(List<MessageId> var1, MailboxSession var2) throws MailboxException;

    public void setInMailboxes(MessageId var1, Collection<MailboxId> var2, MailboxSession var3) throws MailboxException;

    default public List<MessageResult> getMessage(MessageId messageId, FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
        return this.getMessages((Collection<MessageId>)ImmutableList.of((Object)messageId), fetchGroup, mailboxSession);
    }

    default public DeleteResult delete(MessageId messageId, MailboxSession mailboxSession) throws MailboxException {
        return this.delete((List<MessageId>)ImmutableList.of((Object)messageId), mailboxSession);
    }
}

