/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;

public class RabbitMQConfiguration {
    private static String USE_SSL = "ssl.enabled";
    private static String USE_SSL_MANAGEMENT = "ssl.management.enabled";
    private static String SSL_TRUST_STORE_PATH = "ssl.truststore";
    private static String SSL_TRUST_STORE_PASSWORD = "ssl.truststore.password";
    private static String SSL_VALIDATION_STRATEGY = "ssl.validation.strategy";
    private static String SSL_HOSTNAME_VERIFIER = "ssl.hostname.verifier";
    private static String SSL_KEY_STORE_PATH = "ssl.keystore";
    private static String SSL_KEY_STORE_PASSWORD = "ssl.keystore.password";
    private static final String URI_PROPERTY_NAME = "uri";
    private static final String MANAGEMENT_URI_PROPERTY_NAME = "management.uri";
    private final URI uri;
    private final URI managementUri;
    private final int maxRetries;
    private final int minDelayInMs;
    private final int connectionTimeoutInMs;
    private final int channelRpcTimeoutInMs;
    private final int handshakeTimeoutInMs;
    private final int shutdownTimeoutInMs;
    private final int networkRecoveryIntervalInMs;
    private final Boolean useSsl;
    private final Boolean useSslManagement;
    private final SSLConfiguration sslConfiguration;
    private final ManagementCredentials managementCredentials;

    public static RequireAmqpUri builder() {
        return amqpUri -> managementUri -> managementCredentials -> new Builder(amqpUri, managementUri, managementCredentials);
    }

    public static RabbitMQConfiguration from(Configuration configuration) {
        String uriAsString = configuration.getString(URI_PROPERTY_NAME);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)uriAsString) ? 1 : 0) != 0, (Object)"You need to specify the URI of RabbitMQ");
        URI amqpUri = RabbitMQConfiguration.checkURI(uriAsString);
        String managementUriAsString = configuration.getString(MANAGEMENT_URI_PROPERTY_NAME);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)managementUriAsString) ? 1 : 0) != 0, (Object)"You need to specify the management URI of RabbitMQ");
        URI managementUri = RabbitMQConfiguration.checkURI(managementUriAsString);
        Boolean useSsl = configuration.getBoolean(USE_SSL, false);
        Boolean useSslForManagement = configuration.getBoolean(USE_SSL_MANAGEMENT, false);
        ManagementCredentials managementCredentials = ManagementCredentials.from(configuration);
        return RabbitMQConfiguration.builder().amqpUri(amqpUri).managementUri(managementUri).managementCredentials(managementCredentials).useSsl(useSsl).useSslManagement(useSslForManagement).sslConfiguration(RabbitMQConfiguration.sslConfiguration(configuration)).build();
    }

    private static URI checkURI(String uri) {
        try {
            return URI.create(uri);
        }
        catch (Exception e) {
            throw new IllegalStateException("You need to specify a valid URI", e);
        }
    }

    private static SSLConfiguration sslConfiguration(Configuration configuration) {
        SSLConfiguration.SSLValidationStrategy sslStrategy = Optional.ofNullable(configuration.getString(SSL_VALIDATION_STRATEGY)).map(SSLConfiguration.SSLValidationStrategy::from).orElse(SSLConfiguration.SSLValidationStrategy.DEFAULT);
        SSLConfiguration.HostNameVerifier hostNameVerifier = Optional.ofNullable(configuration.getString(SSL_HOSTNAME_VERIFIER)).map(SSLConfiguration.HostNameVerifier::from).orElse(SSLConfiguration.HostNameVerifier.DEFAULT);
        return SSLConfiguration.builder().sslStrategy(sslStrategy, RabbitMQConfiguration.getSSLTrustStore(configuration)).hostNameVerifier(hostNameVerifier).sslKeyStore(RabbitMQConfiguration.getSSLKeyStore(configuration)).build();
    }

    private static Optional<SSLConfiguration.SSLTrustStore> getSSLTrustStore(Configuration configuration) {
        String trustStorePath = configuration.getString(SSL_TRUST_STORE_PATH);
        String trustStorePassword = configuration.getString(SSL_TRUST_STORE_PASSWORD);
        if (trustStorePath == null && trustStorePassword == null) {
            return Optional.empty();
        }
        return Optional.of(SSLConfiguration.SSLTrustStore.of(trustStorePath, trustStorePassword));
    }

    private static Optional<SSLConfiguration.SSLKeyStore> getSSLKeyStore(Configuration configuration) {
        String keyStorePath = configuration.getString(SSL_KEY_STORE_PATH);
        String keyStorePassword = configuration.getString(SSL_KEY_STORE_PASSWORD);
        if (keyStorePath == null && keyStorePassword == null) {
            return Optional.empty();
        }
        return Optional.of(SSLConfiguration.SSLKeyStore.of(keyStorePath, keyStorePassword));
    }

    private RabbitMQConfiguration(URI uri, URI managementUri, ManagementCredentials managementCredentials, int maxRetries, int minDelayInMs, int connectionTimeoutInMs, int channelRpcTimeoutInMs, int handshakeTimeoutInMs, int shutdownTimeoutInMs, int networkRecoveryIntervalInMs, Boolean useSsl, Boolean useSslManagement, SSLConfiguration sslConfiguration) {
        this.uri = uri;
        this.managementUri = managementUri;
        this.managementCredentials = managementCredentials;
        this.maxRetries = maxRetries;
        this.minDelayInMs = minDelayInMs;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.channelRpcTimeoutInMs = channelRpcTimeoutInMs;
        this.handshakeTimeoutInMs = handshakeTimeoutInMs;
        this.shutdownTimeoutInMs = shutdownTimeoutInMs;
        this.networkRecoveryIntervalInMs = networkRecoveryIntervalInMs;
        this.useSsl = useSsl;
        this.useSslManagement = useSslManagement;
        this.sslConfiguration = sslConfiguration;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getManagementUri() {
        return this.managementUri;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getMinDelayInMs() {
        return this.minDelayInMs;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public int getChannelRpcTimeoutInMs() {
        return this.channelRpcTimeoutInMs;
    }

    public int getHandshakeTimeoutInMs() {
        return this.handshakeTimeoutInMs;
    }

    public int getShutdownTimeoutInMs() {
        return this.shutdownTimeoutInMs;
    }

    public int getNetworkRecoveryIntervalInMs() {
        return this.networkRecoveryIntervalInMs;
    }

    public ManagementCredentials getManagementCredentials() {
        return this.managementCredentials;
    }

    public Boolean useSsl() {
        return this.useSsl;
    }

    public Boolean useSslManagement() {
        return this.useSslManagement;
    }

    public SSLConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public final boolean equals(Object o) {
        if (o instanceof RabbitMQConfiguration) {
            RabbitMQConfiguration that = (RabbitMQConfiguration)o;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.managementUri, that.managementUri) && Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.minDelayInMs, that.minDelayInMs) && Objects.equals(this.connectionTimeoutInMs, that.connectionTimeoutInMs) && Objects.equals(this.channelRpcTimeoutInMs, that.channelRpcTimeoutInMs) && Objects.equals(this.handshakeTimeoutInMs, that.handshakeTimeoutInMs) && Objects.equals(this.shutdownTimeoutInMs, that.shutdownTimeoutInMs) && Objects.equals(this.networkRecoveryIntervalInMs, that.networkRecoveryIntervalInMs) && Objects.equals(this.managementCredentials, that.managementCredentials) && Objects.equals(this.useSsl, that.useSsl) && Objects.equals(this.useSslManagement, that.useSslManagement) && Objects.equals(this.sslConfiguration, that.sslConfiguration);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.uri, this.managementUri, this.maxRetries, this.minDelayInMs, this.connectionTimeoutInMs, this.channelRpcTimeoutInMs, this.handshakeTimeoutInMs, this.shutdownTimeoutInMs, this.networkRecoveryIntervalInMs, this.managementCredentials, this.useSsl, this.useSslManagement, this.sslConfiguration);
    }

    public static class Builder {
        static final int DEFAULT_MAX_RETRIES = 7;
        static final int DEFAULT_MIN_DELAY = 3000;
        static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
        static final int DEFAULT_CHANNEL_RPC_TIMEOUT = 60000;
        static final int DEFAULT_HANDSHAKE_TIMEOUT = 10000;
        static final int DEFAULT_SHUTDOWN_TIMEOUT = 10000;
        static final int DEFAULT_NETWORK_RECOVERY_INTERVAL = 5000;
        private final URI amqpUri;
        private final URI managementUri;
        private final ManagementCredentials managementCredentials;
        private Optional<Integer> maxRetries;
        private Optional<Integer> minDelayInMs;
        private Optional<Integer> connectionTimeoutInMs;
        private Optional<Integer> channelRpcTimeoutInMs;
        private Optional<Integer> handshakeTimeoutInMs;
        private Optional<Integer> shutdownTimeoutInMs;
        private Optional<Integer> networkRecoveryIntervalInMs;
        private Optional<Boolean> useSsl;
        private Optional<Boolean> useSslManagement;
        private Optional<SSLConfiguration> sslConfiguration;

        private Builder(URI amqpUri, URI managementUri, ManagementCredentials managementCredentials) {
            this.amqpUri = amqpUri;
            this.managementUri = managementUri;
            this.managementCredentials = managementCredentials;
            this.maxRetries = Optional.empty();
            this.minDelayInMs = Optional.empty();
            this.connectionTimeoutInMs = Optional.empty();
            this.channelRpcTimeoutInMs = Optional.empty();
            this.handshakeTimeoutInMs = Optional.empty();
            this.shutdownTimeoutInMs = Optional.empty();
            this.networkRecoveryIntervalInMs = Optional.empty();
            this.useSsl = Optional.empty();
            this.useSslManagement = Optional.empty();
            this.sslConfiguration = Optional.empty();
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = Optional.of(maxRetries);
            return this;
        }

        public Builder minDelayInMs(int minDelay) {
            this.minDelayInMs = Optional.of(minDelay);
            return this;
        }

        public Builder connectionTimeoutInMs(int connectionTimeout) {
            this.connectionTimeoutInMs = Optional.of(connectionTimeout);
            return this;
        }

        public Builder channelRpcTimeoutInMs(int channelRpcTimeout) {
            this.channelRpcTimeoutInMs = Optional.of(channelRpcTimeout);
            return this;
        }

        public Builder handshakeTimeoutInMs(int handshakeTimeout) {
            this.handshakeTimeoutInMs = Optional.of(handshakeTimeout);
            return this;
        }

        public Builder shutdownTimeoutInMs(int shutdownTimeout) {
            this.shutdownTimeoutInMs = Optional.of(shutdownTimeout);
            return this;
        }

        public Builder networkRecoveryIntervalInMs(int networkRecoveryInterval) {
            this.networkRecoveryIntervalInMs = Optional.of(networkRecoveryInterval);
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = Optional.ofNullable(useSsl);
            return this;
        }

        public Builder useSslManagement(Boolean useSslForManagement) {
            this.useSslManagement = Optional.of(useSslForManagement);
            return this;
        }

        public Builder sslConfiguration(SSLConfiguration sslConfiguration) {
            this.sslConfiguration = Optional.of(sslConfiguration);
            return this;
        }

        public RabbitMQConfiguration build() {
            Preconditions.checkNotNull((Object)this.amqpUri, (Object)"'amqpUri' should not be null");
            Preconditions.checkNotNull((Object)this.managementUri, (Object)"'managementUri' should not be null");
            Preconditions.checkNotNull((Object)this.managementCredentials, (Object)"'managementCredentials' should not be null");
            return new RabbitMQConfiguration(this.amqpUri, this.managementUri, this.managementCredentials, this.maxRetries.orElse(7), this.minDelayInMs.orElse(3000), this.connectionTimeoutInMs.orElse(60000), this.channelRpcTimeoutInMs.orElse(60000), this.handshakeTimeoutInMs.orElse(10000), this.shutdownTimeoutInMs.orElse(10000), this.networkRecoveryIntervalInMs.orElse(5000), this.useSsl.orElse(false), this.useSslManagement.orElse(false), this.sslConfiguration.orElse(SSLConfiguration.defaultBehavior()));
        }
    }

    @FunctionalInterface
    public static interface RequireManagementCredentials {
        public Builder managementCredentials(ManagementCredentials var1);
    }

    @FunctionalInterface
    public static interface RequireManagementUri {
        public RequireManagementCredentials managementUri(URI var1);
    }

    @FunctionalInterface
    public static interface RequireAmqpUri {
        public RequireManagementUri amqpUri(URI var1);
    }

    public static class ManagementCredentials {
        private static final String MANAGEMENT_CREDENTIAL_USER_PROPERTY = "management.user";
        private static final String MANAGEMENT_CREDENTIAL_PASSWORD_PROPERTY = "management.password";
        private final String user;
        private final char[] password;

        static ManagementCredentials from(Configuration configuration) {
            String user = configuration.getString(MANAGEMENT_CREDENTIAL_USER_PROPERTY);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0, (Object)"You need to specify the management.user property as username of rabbitmq management admin account");
            String passwordString = configuration.getString(MANAGEMENT_CREDENTIAL_PASSWORD_PROPERTY);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)passwordString) ? 1 : 0) != 0, (Object)"You need to specify the management.password property as password of rabbitmq management admin account");
            return new ManagementCredentials(user, passwordString.toCharArray());
        }

        ManagementCredentials(String user, char[] password) {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)password);
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public char[] getPassword() {
            return this.password;
        }

        public final boolean equals(Object o) {
            if (o instanceof ManagementCredentials) {
                ManagementCredentials that = (ManagementCredentials)o;
                return Objects.equals(this.user, that.user) && Arrays.equals(this.password, that.password);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.user, Arrays.hashCode(this.password));
        }
    }

    public static class SSLConfiguration {
        private final SSLValidationStrategy strategy;
        private final HostNameVerifier hostNameVerifier;
        private final Optional<SSLTrustStore> trustStore;
        private final Optional<SSLKeyStore> keyStore;

        static SSLConfiguration defaultBehavior() {
            return new SSLConfiguration(SSLValidationStrategy.DEFAULT, HostNameVerifier.DEFAULT, Optional.empty(), Optional.empty());
        }

        static Builder.RequireSSLStrategyTrustStore builder() {
            return (strategy, trustStore) -> hostNameVerifier -> new Builder.ReadyToBuild(strategy, hostNameVerifier, trustStore);
        }

        private SSLConfiguration(SSLValidationStrategy strategy, HostNameVerifier hostNameVerifier, Optional<SSLTrustStore> trustStore, Optional<SSLKeyStore> keyStore) {
            Preconditions.checkNotNull((Object)((Object)strategy));
            Preconditions.checkNotNull(trustStore);
            Preconditions.checkNotNull((Object)((Object)hostNameVerifier));
            Preconditions.checkArgument((strategy != SSLValidationStrategy.OVERRIDE || trustStore.isPresent() ? 1 : 0) != 0, (String)"%s strategy requires trustStore to be present", (Object)SSLValidationStrategy.OVERRIDE.name());
            this.strategy = strategy;
            this.trustStore = trustStore;
            this.keyStore = keyStore;
            this.hostNameVerifier = hostNameVerifier;
        }

        public SSLValidationStrategy getStrategy() {
            return this.strategy;
        }

        public Optional<SSLTrustStore> getTrustStore() {
            return this.trustStore;
        }

        public Optional<SSLKeyStore> getKeyStore() {
            return this.keyStore;
        }

        public HostNameVerifier getHostNameVerifier() {
            return this.hostNameVerifier;
        }

        public final boolean equals(Object o) {
            if (o instanceof SSLConfiguration) {
                SSLConfiguration that = (SSLConfiguration)o;
                return Objects.equals((Object)this.strategy, (Object)that.strategy) && Objects.equals(this.trustStore, that.trustStore) && Objects.equals(this.keyStore, that.keyStore) && Objects.equals((Object)this.hostNameVerifier, (Object)that.hostNameVerifier);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.strategy, this.trustStore, this.keyStore, this.hostNameVerifier});
        }

        static class Builder {
            Builder() {
            }

            static class ReadyToBuild {
                private final SSLValidationStrategy sslValidationStrategy;
                private final HostNameVerifier hostNameVerifier;
                private Optional<SSLTrustStore> sslTrustStore;
                private Optional<SSLKeyStore> sslKeyStore;

                private ReadyToBuild(SSLValidationStrategy sslValidationStrategy, HostNameVerifier hostNameVerifier, Optional<SSLTrustStore> sslTrustStore) {
                    this.sslValidationStrategy = sslValidationStrategy;
                    this.hostNameVerifier = hostNameVerifier;
                    this.sslTrustStore = sslTrustStore;
                    this.sslKeyStore = Optional.empty();
                }

                public ReadyToBuild sslKeyStore(Optional<SSLKeyStore> sslKeyStore) {
                    this.sslKeyStore = sslKeyStore;
                    return this;
                }

                public SSLConfiguration build() {
                    return new SSLConfiguration(this.sslValidationStrategy, this.hostNameVerifier, this.sslTrustStore, this.sslKeyStore);
                }
            }

            @FunctionalInterface
            static interface RequireHostNameVerifier {
                public ReadyToBuild hostNameVerifier(HostNameVerifier var1);

                default public ReadyToBuild acceptAnyHostNameVerifier() {
                    return this.hostNameVerifier(HostNameVerifier.ACCEPT_ANY_HOSTNAME);
                }

                default public ReadyToBuild defaultHostNameVerifier() {
                    return this.hostNameVerifier(HostNameVerifier.DEFAULT);
                }
            }

            @FunctionalInterface
            static interface RequireSSLStrategyTrustStore {
                public RequireHostNameVerifier sslStrategy(SSLValidationStrategy var1, Optional<SSLTrustStore> var2);

                default public RequireHostNameVerifier strategyIgnore() {
                    return this.sslStrategy(SSLValidationStrategy.IGNORE, Optional.empty());
                }

                default public RequireHostNameVerifier strategyOverride(SSLTrustStore trustStore) {
                    return this.sslStrategy(SSLValidationStrategy.OVERRIDE, Optional.of(trustStore));
                }

                default public RequireHostNameVerifier strategyDefault() {
                    return this.sslStrategy(SSLValidationStrategy.DEFAULT, Optional.empty());
                }
            }
        }

        public static class SSLTrustStore {
            private final File file;
            private final char[] password;

            public static SSLTrustStore of(String filePath, String password) {
                return new SSLTrustStore(filePath, password);
            }

            private SSLTrustStore(String filePath, String password) {
                Preconditions.checkNotNull((Object)filePath, (String)"%s cannot be null when %s is specified", (Object)SSL_TRUST_STORE_PATH, (Object)SSL_TRUST_STORE_PASSWORD);
                Preconditions.checkNotNull((Object)password, (String)"%s cannot be null when %s is specified", (Object)SSL_TRUST_STORE_PASSWORD, (Object)SSL_TRUST_STORE_PATH);
                Preconditions.checkArgument((boolean)Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]), (String)"the file '%s' from property '%s' doesn't exist", (Object)filePath, (Object)SSL_TRUST_STORE_PATH);
                this.file = new File(filePath);
                this.password = password.toCharArray();
            }

            public File getFile() {
                return this.file;
            }

            public char[] getPassword() {
                return this.password;
            }

            public final boolean equals(Object o) {
                if (o instanceof SSLTrustStore) {
                    SSLTrustStore that = (SSLTrustStore)o;
                    return Objects.equals(this.file, that.file) && Arrays.equals(this.password, that.password);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.file, Arrays.hashCode(this.password));
            }
        }

        public static class SSLKeyStore {
            private final File file;
            private final char[] password;

            public static SSLKeyStore of(String filePath, String password) {
                return new SSLKeyStore(filePath, password);
            }

            private SSLKeyStore(String filePath, String password) {
                Preconditions.checkNotNull((Object)filePath, (String)"%s cannot be null when %s is specified", (Object)SSL_KEY_STORE_PATH, (Object)SSL_KEY_STORE_PASSWORD);
                Preconditions.checkNotNull((Object)password, (String)"%s cannot be null when %s is specified", (Object)SSL_KEY_STORE_PASSWORD, (Object)SSL_KEY_STORE_PATH);
                Preconditions.checkArgument((boolean)Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]), (String)"the file '%s' from property '%s' doesn't exist", (Object)filePath, (Object)SSL_KEY_STORE_PATH);
                this.file = new File(filePath);
                this.password = password.toCharArray();
            }

            public File getFile() {
                return this.file;
            }

            public char[] getPassword() {
                return this.password;
            }

            public final boolean equals(Object o) {
                if (o instanceof SSLKeyStore) {
                    SSLKeyStore that = (SSLKeyStore)o;
                    return Objects.equals(this.file, that.file) && Arrays.equals(this.password, that.password);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.file, Arrays.hashCode(this.password));
            }
        }

        public static enum HostNameVerifier {
            DEFAULT,
            ACCEPT_ANY_HOSTNAME;


            static HostNameVerifier from(String rawValue) {
                Preconditions.checkNotNull((Object)rawValue);
                return Stream.of(HostNameVerifier.values()).filter(verifier -> verifier.name().equalsIgnoreCase(rawValue)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("invalid HostNameVerifier '%s'", rawValue)));
            }
        }

        public static enum SSLValidationStrategy {
            DEFAULT,
            IGNORE,
            OVERRIDE;


            static SSLValidationStrategy from(String rawValue) {
                Preconditions.checkNotNull((Object)rawValue);
                return Stream.of(SSLValidationStrategy.values()).filter(strategy -> strategy.name().equalsIgnoreCase(rawValue)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("invalid strategy '%s'", rawValue)));
            }
        }
    }
}

