/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.mdc;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.webadmin.mdc.RequestId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

public class LoggingResponseFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingResponseFilter.class);
    private static final String STATUS = "status";
    private static final String RESPONSE_BODY = "response-body";

    public void handle(Request request, Response response) {
        RequestId requestId = (RequestId)request.attribute("requestId");
        MDCStructuredLogger.forLogger((Logger)LOGGER).addField("requestId", (Object)requestId.asString()).addField("ip", (Object)request.ip()).addField("endpoint", (Object)request.url()).addField("method", (Object)request.requestMethod()).addField("LOGIN", request.attribute("LOGIN")).addField("queryParameters", (Object)ImmutableSet.copyOf((Collection)request.queryParams())).addField(STATUS, (Object)response.status()).addField(RESPONSE_BODY, (Object)response.body()).log(logger -> logger.info("WebAdmin response received"));
    }
}

