/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.cassandra.CassandraDomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class CassandraDomainListModule
extends AbstractModule {
    public void configure() {
        this.bind(CassandraDomainList.class).in(Scopes.SINGLETON);
        this.bind(DomainList.class).to(CassandraDomainList.class);
        Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class).addBinding().toInstance((Object)org.apache.james.domainlist.cassandra.CassandraDomainListModule.MODULE);
    }

    @Provides
    @Singleton
    public DomainListConfiguration provideDomainListConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return DomainListConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("domainlist"));
    }

    @ProvidesIntoSet
    InitializationOperation configureDomainList(DomainListConfiguration configuration, CassandraDomainList cassandraDomainList) {
        return InitilizationOperationBuilder.forClass(CassandraDomainList.class).init(() -> cassandraDomainList.configure(configuration));
    }
}

