/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.language.CSimpleExpression;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.JoorExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.util.ObjectHelper;

public final class Builder {
    private Builder() {
    }

    @Deprecated
    public static ValueBuilder bean(Object beanOrBeanRef) {
        return Builder.method(beanOrBeanRef, null);
    }

    @Deprecated
    public static ValueBuilder bean(Object beanOrBeanRef, String method) {
        return Builder.method(beanOrBeanRef, method);
    }

    @Deprecated
    public static ValueBuilder bean(Class<?> beanType, String method) {
        return Builder.method(beanType, method);
    }

    public static ValueBuilder method(Object beanOrBeanRef) {
        return Builder.method(beanOrBeanRef, null);
    }

    public static ValueBuilder method(Object beanOrBeanRef, String method) {
        MethodCallExpression exp = beanOrBeanRef instanceof String ? new MethodCallExpression((String)beanOrBeanRef, method) : new MethodCallExpression(beanOrBeanRef, method);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder method(Class<?> beanType, String method) {
        MethodCallExpression exp = new MethodCallExpression(beanType, method);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder constant(Object value) {
        Expression exp = value instanceof String ? new ConstantExpression((String)value) : ExpressionBuilder.constantExpression((Object)value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder language(String language, String expression) {
        LanguageExpression exp = new LanguageExpression(language, expression);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder csimple(String value) {
        CSimpleExpression exp = new CSimpleExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder csimple(String value, Class<?> resultType) {
        CSimpleExpression exp = new CSimpleExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder simple(String value) {
        SimpleExpression exp = new SimpleExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder simple(String value, Class<?> resultType) {
        SimpleExpression exp = new SimpleExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder joor(String value) {
        JoorExpression exp = new JoorExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder joor(String value, Class<?> resultType) {
        JoorExpression exp = new JoorExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder jsonpath(String value) {
        JsonPathExpression exp = new JsonPathExpression(value);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder jsonpath(String value, Class<?> resultType) {
        JsonPathExpression exp = new JsonPathExpression(value);
        exp.setResultType(resultType);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder header(String name) {
        HeaderExpression exp = new HeaderExpression(name);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder exchangeProperty(String name) {
        ExchangePropertyExpression exp = new ExchangePropertyExpression(name);
        return new ValueBuilder(exp);
    }

    public static ValueBuilder body() {
        SimpleExpression exp = new SimpleExpression("${body}");
        return new ValueBuilder(exp);
    }

    public static <T> ValueBuilder bodyAs(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        SimpleExpression exp = new SimpleExpression(String.format("${bodyAs(%s)}", type.getCanonicalName()));
        return new ValueBuilder(exp);
    }

    public static ValueBuilder systemProperty(String name) {
        SimpleExpression exp = new SimpleExpression(String.format("${sys.%s}", name));
        return new ValueBuilder(exp);
    }

    public static ValueBuilder systemProperty(String name, String defaultValue) {
        return new ValueBuilder(ExpressionBuilder.systemPropertyExpression((String)name, (String)defaultValue));
    }

    public static ValueBuilder exceptionMessage() {
        SimpleExpression exp = new SimpleExpression("${exception.message}");
        return new ValueBuilder(exp);
    }

    public static ValueBuilder exceptionStackTrace() {
        SimpleExpression exp = new SimpleExpression("${exception.stacktrace}");
        return new ValueBuilder(exp);
    }

    public static ValueBuilder regexReplaceAll(Expression content, String regex, String replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll((Expression)content, (String)regex, (String)replacement);
        return new ValueBuilder(newExp);
    }

    public static ValueBuilder regexReplaceAll(Expression content, String regex, Expression replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll((Expression)content, (String)regex, (Expression)replacement);
        return new ValueBuilder(newExp);
    }
}

