/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.blob;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import org.apache.james.blob.api.BucketName;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.vault.blob.BlobStoreDeletedMessageVault;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class BlobStoreVaultGarbageCollectionTask
implements Task {
    static final TaskType TYPE = TaskType.of((String)"deleted-messages-blob-store-based-garbage-collection");
    private final Flux<BucketName> retentionOperation;
    private final ZonedDateTime beginningOfRetentionPeriod;
    private final Collection<BucketName> deletedBuckets;

    private BlobStoreVaultGarbageCollectionTask(BlobStoreDeletedMessageVault deletedMessageVault) {
        this.beginningOfRetentionPeriod = deletedMessageVault.getBeginningOfRetentionPeriod();
        this.retentionOperation = deletedMessageVault.deleteExpiredMessages(this.beginningOfRetentionPeriod);
        this.deletedBuckets = new ConcurrentLinkedQueue<BucketName>();
    }

    public Task.Result run() {
        this.retentionOperation.doOnNext(this.deletedBuckets::add).subscribeOn(Schedulers.elastic()).then().block();
        return Task.Result.COMPLETED;
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.beginningOfRetentionPeriod, (ImmutableSet<BucketName>)ImmutableSet.copyOf(this.deletedBuckets), Clock.systemUTC().instant()));
    }

    public static class Factory {
        private final BlobStoreDeletedMessageVault deletedMessageVault;

        @Inject
        public Factory(BlobStoreDeletedMessageVault deletedMessageVault) {
            this.deletedMessageVault = deletedMessageVault;
        }

        public BlobStoreVaultGarbageCollectionTask create() {
            return new BlobStoreVaultGarbageCollectionTask(this.deletedMessageVault);
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final ZonedDateTime beginningOfRetentionPeriod;
        private final ImmutableSet<BucketName> deletedBuckets;
        private final Instant timestamp;

        AdditionalInformation(ZonedDateTime beginningOfRetentionPeriod, ImmutableSet<BucketName> deletedBuckets, Instant timestamp) {
            this.beginningOfRetentionPeriod = beginningOfRetentionPeriod;
            this.deletedBuckets = deletedBuckets;
            this.timestamp = timestamp;
        }

        public ZonedDateTime getBeginningOfRetentionPeriod() {
            return this.beginningOfRetentionPeriod;
        }

        public List<String> getDeletedBuckets() {
            return (List)this.deletedBuckets.stream().map(BucketName::asString).collect(Guavate.toImmutableList());
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

