/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.vacation;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

public class Vacation {
    public static final String ID = "singleton";
    public static final boolean DEFAULT_DISABLED = false;
    private final boolean isEnabled;
    private final Optional<ZonedDateTime> fromDate;
    private final Optional<ZonedDateTime> toDate;
    private final Optional<String> subject;
    private final Optional<String> textBody;
    private final Optional<String> htmlBody;

    public static Builder builder() {
        return new Builder();
    }

    private Vacation(boolean isEnabled, Optional<ZonedDateTime> fromDate, Optional<ZonedDateTime> toDate, Optional<String> textBody, Optional<String> subject, Optional<String> htmlBody) {
        this.isEnabled = isEnabled;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.textBody = textBody;
        this.subject = subject;
        this.htmlBody = htmlBody;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Optional<ZonedDateTime> getFromDate() {
        return this.fromDate;
    }

    public Optional<ZonedDateTime> getToDate() {
        return this.toDate;
    }

    public Optional<String> getTextBody() {
        return this.textBody;
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public boolean isActiveAtDate(ZonedDateTime instant) {
        Preconditions.checkNotNull((Object)instant);
        return this.isEnabled && this.isAfterOrEqualToFromDate(instant) != false && this.isBeforeOrEqualToToDate(instant) != false;
    }

    private Boolean isAfterOrEqualToFromDate(ZonedDateTime instant) {
        return this.fromDate.map(date -> date.isBefore(instant) || date.equals(instant)).orElse(true);
    }

    private Boolean isBeforeOrEqualToToDate(ZonedDateTime instant) {
        return this.toDate.map(date -> date.isAfter(instant) || date.equals(instant)).orElse(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vacation vacation = (Vacation)o;
        return Objects.equals(this.isEnabled, vacation.isEnabled) && Objects.equals(this.fromDate, vacation.fromDate) && Objects.equals(this.toDate, vacation.toDate) && Objects.equals(this.textBody, vacation.textBody) && Objects.equals(this.subject, vacation.subject) && Objects.equals(this.htmlBody, vacation.htmlBody);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.fromDate, this.toDate, this.textBody, this.subject, this.htmlBody);
    }

    public static class Builder {
        private Optional<Boolean> isEnabled = Optional.empty();
        private Optional<ZonedDateTime> fromDate = Optional.empty();
        private Optional<ZonedDateTime> toDate = Optional.empty();
        private Optional<String> textBody = Optional.empty();
        private Optional<String> subject = Optional.empty();
        private Optional<String> htmlBody = Optional.empty();

        public Builder enabled(boolean enabled) {
            this.isEnabled = Optional.of(enabled);
            return this;
        }

        public Builder fromDate(Optional<ZonedDateTime> fromDate) {
            Preconditions.checkNotNull(fromDate);
            this.fromDate = fromDate;
            return this;
        }

        public Builder toDate(Optional<ZonedDateTime> toDate) {
            Preconditions.checkNotNull(toDate);
            this.toDate = toDate;
            return this;
        }

        public Builder textBody(Optional<String> textBody) {
            Preconditions.checkNotNull(textBody);
            this.textBody = textBody;
            return this;
        }

        public Builder textBody(String textBody) {
            Preconditions.checkNotNull((Object)textBody);
            this.textBody = Optional.of(textBody);
            return this;
        }

        public Builder subject(Optional<String> subject) {
            Preconditions.checkNotNull(subject);
            this.subject = subject;
            return this;
        }

        public Builder htmlBody(Optional<String> htmlBody) {
            Preconditions.checkNotNull(htmlBody);
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder htmlBody(String htmlBody) {
            Preconditions.checkNotNull((Object)htmlBody);
            this.htmlBody = Optional.of(htmlBody);
            return this;
        }

        public Builder copy(Vacation vacation) {
            this.textBody = vacation.getTextBody();
            this.fromDate = vacation.getFromDate();
            this.toDate = vacation.getToDate();
            this.isEnabled = Optional.of(vacation.isEnabled());
            this.subject = vacation.getSubject();
            return this;
        }

        public Vacation build() {
            boolean enabled = this.isEnabled.orElse(false);
            return new Vacation(enabled, this.fromDate, this.toDate, this.textBody, this.subject, this.htmlBody);
        }
    }
}

