/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.Command;
import org.apache.james.jmap.api.filtering.Rule;

public class DefineRulesCommand
implements Command {
    private final Username username;
    private final List<Rule> rules;

    public DefineRulesCommand(Username username, List<Rule> rules) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull(rules);
        this.username = username;
        this.rules = rules;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Username getUsername() {
        return this.username;
    }

    public final boolean equals(Object o) {
        if (o instanceof DefineRulesCommand) {
            DefineRulesCommand that = (DefineRulesCommand)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.rules, that.rules);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.username, this.rules);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.username).add("rules", this.rules).toString();
    }
}

