/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.DefaultMailboxes;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DefaultMailboxesProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMailboxesProvisioner.class);
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    public DefaultMailboxesProvisioner(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.metricFactory = metricFactory;
    }

    public Mono<Void> createMailboxesIfNeeded(MailboxSession session) {
        return (Mono)this.metricFactory.decorateSupplierWithTimerMetric("JMAP-mailboxes-provisioning", () -> {
            Username username = session.getUser();
            return this.createDefaultMailboxes(username);
        });
    }

    private Mono<Void> createDefaultMailboxes(Username username) {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        return Flux.fromIterable((Iterable)DefaultMailboxes.DEFAULT_MAILBOXES).map(this.toMailboxPath(session)).filterWhen(mailboxPath -> this.mailboxDoesntExist((MailboxPath)mailboxPath, session), 16).concatMap(mailboxPath -> Mono.fromRunnable(() -> this.createMailbox((MailboxPath)mailboxPath, session)).subscribeOn(Schedulers.elastic())).then();
    }

    private Mono<Boolean> mailboxDoesntExist(MailboxPath mailboxPath, MailboxSession session) {
        try {
            return Mono.from((Publisher)this.mailboxManager.mailboxExists(mailboxPath, session)).map(FunctionalUtils.negate());
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private Function<String, MailboxPath> toMailboxPath(MailboxSession session) {
        return mailbox -> MailboxPath.forUser((Username)session.getUser(), (String)mailbox);
    }

    private void createMailbox(MailboxPath mailboxPath, MailboxSession session) {
        try {
            Optional mailboxId = this.mailboxManager.createMailbox(mailboxPath, session);
            if (mailboxId.isPresent()) {
                this.subscriptionManager.subscribe(session, mailboxPath.getName());
            }
            LOGGER.info("Provisioning {}. {} created.", (Object)mailboxPath, (Object)mailboxId);
        }
        catch (MailboxExistsException e) {
            LOGGER.info("Mailbox {} have been created concurrently", (Object)mailboxPath);
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

