/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.event;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.stream.MimeConfig;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PopulateEmailQueryViewListener
implements EventListener.ReactiveGroupEventListener {
    static final Group GROUP = new PopulateEmailQueryViewListenerGroup();
    private static final int CONCURRENCY = 5;
    private final MessageIdManager messageIdManager;
    private final EmailQueryView view;
    private final SessionProvider sessionProvider;

    @Inject
    public PopulateEmailQueryViewListener(MessageIdManager messageIdManager, EmailQueryView view, SessionProvider sessionProvider) {
        this.messageIdManager = messageIdManager;
        this.view = view;
        this.sessionProvider = sessionProvider;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Added) {
            return this.handleAdded((MailboxEvents.Added)event);
        }
        if (event instanceof MailboxEvents.Expunged) {
            return this.handleExpunged((MailboxEvents.Expunged)event);
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            return this.handleMailboxDeletion((MailboxEvents.MailboxDeletion)event);
        }
        return Mono.empty();
    }

    private Publisher<Void> handleMailboxDeletion(MailboxEvents.MailboxDeletion mailboxDeletion) {
        return this.view.delete(mailboxDeletion.getMailboxId());
    }

    private Publisher<Void> handleExpunged(MailboxEvents.Expunged expunged) {
        return Flux.fromStream(expunged.getUids().stream().map(uid -> expunged.getMetaData(uid).getMessageId())).concatMap(messageId -> this.view.delete(expunged.getMailboxId(), messageId)).then();
    }

    private Mono<Void> handleAdded(MailboxEvents.Added added) {
        MailboxSession session = this.sessionProvider.createSystemSession(added.getUsername());
        return Flux.fromStream(added.getUids().stream().map(arg_0 -> ((MailboxEvents.Added)added).getMetaData(arg_0))).flatMap(messageMetaData -> this.handleAdded(added, (MessageMetaData)messageMetaData, session), 5).then();
    }

    private Mono<Void> handleAdded(MailboxEvents.Added added, MessageMetaData messageMetaData, MailboxSession session) {
        MessageId messageId = messageMetaData.getMessageId();
        ZonedDateTime receivedAt = ZonedDateTime.ofInstant(messageMetaData.getInternalDate().toInstant(), ZoneOffset.UTC);
        return Flux.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableList.of((Object)messageId), FetchGroup.HEADERS, session)).next().map((Function)Throwing.function(this::parseMessage)).map(message -> Optional.ofNullable(message.getDate()).orElse(messageMetaData.getInternalDate())).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC)).flatMap(sentAt -> this.view.save(added.getMailboxId(), sentAt, receivedAt, messageId));
    }

    private Message parseMessage(MessageResult messageResult) throws IOException, MailboxException {
        return Message.Builder.of().use(MimeConfig.PERMISSIVE).parse(messageResult.getFullContent().getInputStream()).build();
    }

    public static class PopulateEmailQueryViewListenerGroup
    extends Group {
    }
}

