/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils.quotas;

import java.util.Optional;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;

public class QuotaLoaderWithDefaultPreloaded
extends QuotaLoader {
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;
    private final Optional<Quotas> preloadedUserDefaultQuotas;
    private final MailboxSession session;

    public QuotaLoaderWithDefaultPreloaded(QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MailboxSession session) throws MailboxException {
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
        this.session = session;
        this.preloadedUserDefaultQuotas = Optional.of(this.getUserDefaultQuotas());
    }

    @Override
    public Quotas getQuotas(MailboxPath mailboxPath) throws MailboxException {
        QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
        Quotas.QuotaId quotaId = Quotas.QuotaId.fromQuotaRoot(quotaRoot);
        if (this.containsQuotaId(this.preloadedUserDefaultQuotas, quotaId)) {
            return this.preloadedUserDefaultQuotas.get();
        }
        QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
        return Quotas.from(quotaId, Quotas.Quota.from(this.quotaToValue(quotas.getStorageQuota()), this.quotaToValue(quotas.getMessageQuota())));
    }

    private boolean containsQuotaId(Optional<Quotas> preloadedUserDefaultQuotas, Quotas.QuotaId quotaId) {
        return preloadedUserDefaultQuotas.map(Quotas::getQuotas).map(quotaIdQuotaMap -> quotaIdQuotaMap.containsKey(quotaId)).orElse(false);
    }

    private Quotas getUserDefaultQuotas() throws MailboxException {
        QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(MailboxPath.inbox((MailboxSession)this.session));
        Quotas.QuotaId quotaId = Quotas.QuotaId.fromQuotaRoot(quotaRoot);
        QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
        return Quotas.from(quotaId, Quotas.Quota.from(this.quotaToValue(quotas.getStorageQuota()), this.quotaToValue(quotas.getMessageQuota())));
    }
}

