/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.send;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.send.MailMetadata;
import org.apache.james.jmap.draft.send.exception.MailShouldBeInOutboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxRoleNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostDequeueDecorator
extends MailQueueItemDecoratorFactory.MailQueueItemDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(PostDequeueDecorator.class);
    private static final Attribute IS_DELIVERED = Attribute.convertToAttribute((String)"DELIVERED", (Object)"DELIVERED");
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;
    private final MessageIdManager messageIdManager;
    private final SystemMailboxesProvider systemMailboxesProvider;

    public PostDequeueDecorator(MailQueue.MailQueueItem mailQueueItem, MailboxManager mailboxManager, MessageId.Factory messageIdFactory, MessageIdManager messageIdManager, SystemMailboxesProvider systemMailboxesProvider) {
        super(mailQueueItem);
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
        this.messageIdManager = messageIdManager;
        this.systemMailboxesProvider = systemMailboxesProvider;
    }

    public Mail getMail() {
        return this.mailQueueItem.getMail();
    }

    public void done(boolean success) throws MailQueue.MailQueueException {
        this.mailQueueItem.done(success);
        if (success && this.mandatoryJmapMetaDataIsPresent()) {
            Optional<?> optionalRawMessageId = this.retrieveMessageId();
            MessageId messageId = this.messageIdFactory.fromString((String)optionalRawMessageId.get());
            Optional<String> username = this.retrieveUsername();
            if (!this.getMail().getAttribute(IS_DELIVERED.getName()).isPresent()) {
                try {
                    MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)username.get()));
                    this.moveFromOutboxToSentWithSeenFlag(messageId, mailboxSession);
                    this.getMail().setAttribute(IS_DELIVERED);
                }
                catch (MailShouldBeInOutboxException e) {
                    LOG.info("Message does not exist on Outbox anymore, it could have already been sent", (Throwable)((Object)e));
                }
                catch (MailboxException e) {
                    throw new MailQueue.MailQueueException(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
    }

    private Optional<?> retrieveMessageId() {
        return AttributeUtils.getAttributeValueFromMail((Mail)this.getMail(), (AttributeName)MailMetadata.MAIL_METADATA_MESSAGE_ID_ATTRIBUTE);
    }

    private Optional<String> retrieveUsername() {
        return AttributeUtils.getValueAndCastFromMail((Mail)this.getMail(), (AttributeName)MailMetadata.MAIL_METADATA_USERNAME_ATTRIBUTE, String.class);
    }

    private boolean mandatoryJmapMetaDataIsPresent() {
        return this.checkMessageIdAttribute() && this.checkUsernameAttribute();
    }

    private boolean checkMessageIdAttribute() {
        return this.retrieveMessageId().map(this::validateMessageId).orElse(false);
    }

    private boolean validateMessageId(Object messageId) {
        if (messageId instanceof String) {
            try {
                this.messageIdFactory.fromString((String)messageId);
                return true;
            }
            catch (Exception e) {
                LOG.error("Invalid messageId: {}", messageId, (Object)e);
            }
        }
        LOG.error("Non-String messageId {} has type {}", messageId, messageId.getClass());
        return false;
    }

    private boolean checkUsernameAttribute() {
        return this.retrieveUsername().isPresent();
    }

    private void moveFromOutboxToSentWithSeenFlag(MessageId messageId, MailboxSession mailboxSession) throws MailQueue.MailQueueException, MailboxException {
        this.assertMessageBelongsToOutbox(messageId, mailboxSession);
        MailboxId sentMailboxId = this.getSentMailboxId(mailboxSession);
        this.messageIdManager.setInMailboxes(messageId, (Collection)ImmutableList.of((Object)sentMailboxId), mailboxSession);
        this.messageIdManager.setFlags(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, messageId, (List)ImmutableList.of((Object)sentMailboxId), mailboxSession);
    }

    private void assertMessageBelongsToOutbox(MessageId messageId, MailboxSession mailboxSession) throws MailboxException, MailShouldBeInOutboxException {
        MailboxId outboxMailboxId = this.getOutboxMailboxId(mailboxSession);
        List messages = this.messageIdManager.getMessage(messageId, FetchGroup.MINIMAL, mailboxSession);
        for (MessageResult message : messages) {
            if (!message.getMailboxId().equals(outboxMailboxId)) continue;
            return;
        }
        throw new MailShouldBeInOutboxException(messageId);
    }

    private MailboxId getSentMailboxId(MailboxSession session) throws MailboxRoleNotFoundException, MailboxException {
        return this.systemMailboxesProvider.findMailbox(Role.SENT, session.getUser()).getId();
    }

    private MailboxId getOutboxMailboxId(MailboxSession session) throws MailboxRoleNotFoundException, MailboxException {
        return this.systemMailboxesProvider.findMailbox(Role.OUTBOX, session.getUser()).getId();
    }
}

