/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.model.message.view.MessageMetadataView;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;

public class MessageHeaderView
extends MessageMetadataView {
    private final Optional<String> inReplyToMessageId;
    @JsonFilter(value="headersFilter")
    private final ImmutableMap<String, String> headers;
    private final Optional<Emailer> from;
    private final ImmutableList<Emailer> to;
    private final ImmutableList<Emailer> cc;
    private final ImmutableList<Emailer> bcc;
    private final ImmutableList<Emailer> replyTo;
    private final String subject;
    private final Instant date;

    public static Builder<? extends Builder> messageHeaderBuilder() {
        return new Builder();
    }

    @VisibleForTesting
    MessageHeaderView(MessageId id, BlobId blobId, String threadId, ImmutableList<MailboxId> mailboxIds, Optional<String> inReplyToMessageId, ImmutableMap<String, String> headers, Optional<Emailer> from, ImmutableList<Emailer> to, ImmutableList<Emailer> cc, ImmutableList<Emailer> bcc, ImmutableList<Emailer> replyTo, String subject, Instant date, Number size, Keywords keywords) {
        super(id, blobId, threadId, mailboxIds, size, keywords);
        this.inReplyToMessageId = inReplyToMessageId;
        this.headers = headers;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.replyTo = replyTo;
        this.subject = subject;
        this.date = date;
    }

    public Optional<String> getInReplyToMessageId() {
        return this.inReplyToMessageId;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<Emailer> getFrom() {
        return this.from;
    }

    public ImmutableList<Emailer> getTo() {
        return this.to;
    }

    public ImmutableList<Emailer> getCc() {
        return this.cc;
    }

    public ImmutableList<Emailer> getBcc() {
        return this.bcc;
    }

    public ImmutableList<Emailer> getReplyTo() {
        return this.replyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public Instant getDate() {
        return this.date;
    }

    public static class Builder<S extends Builder<S>>
    extends MessageMetadataView.Builder<S> {
        protected String inReplyToMessageId;
        protected ImmutableMap<String, String> headers;
        protected Optional<Emailer> from = Optional.empty();
        protected final ImmutableList.Builder<Emailer> to = ImmutableList.builder();
        protected final ImmutableList.Builder<Emailer> cc = ImmutableList.builder();
        protected final ImmutableList.Builder<Emailer> bcc = ImmutableList.builder();
        protected final ImmutableList.Builder<Emailer> replyTo = ImmutableList.builder();
        protected String subject;
        protected Instant date;

        protected Builder() {
        }

        public S inReplyToMessageId(String inReplyToMessageId) {
            this.inReplyToMessageId = inReplyToMessageId;
            return (S)this;
        }

        public S headers(ImmutableMap<String, String> headers) {
            this.headers = headers;
            return (S)this;
        }

        public S from(Emailer from) {
            this.from = Optional.of(from);
            return (S)this;
        }

        public S from(Optional<Emailer> from) {
            this.from = from;
            return (S)this;
        }

        public S to(List<Emailer> to) {
            this.to.addAll(to);
            return (S)this;
        }

        public S cc(List<Emailer> cc) {
            this.cc.addAll(cc);
            return (S)this;
        }

        public S bcc(List<Emailer> bcc) {
            this.bcc.addAll(bcc);
            return (S)this;
        }

        public S replyTo(List<Emailer> replyTo) {
            this.replyTo.addAll(replyTo);
            return (S)this;
        }

        public S subject(String subject) {
            this.subject = subject;
            return (S)this;
        }

        public S date(Instant date) {
            this.date = date;
            return (S)this;
        }

        @Override
        public MessageHeaderView build() {
            this.checkState();
            return new MessageHeaderView(this.id, this.blobId, this.threadId, (ImmutableList<MailboxId>)this.mailboxIds, Optional.ofNullable(this.inReplyToMessageId), this.headers, this.from, (ImmutableList<Emailer>)this.to.build(), (ImmutableList<Emailer>)this.cc.build(), (ImmutableList<Emailer>)this.bcc.build(), (ImmutableList<Emailer>)this.replyTo.build(), this.subject, this.date, this.size, this.keywords.orElse(Keywords.DEFAULT_VALUE));
        }

        @Override
        protected void checkState() {
            super.checkState();
            Preconditions.checkState((this.headers != null ? 1 : 0) != 0, (Object)"'headers' is mandatory");
            Preconditions.checkState((this.date != null ? 1 : 0) != 0, (Object)"'date' is mandatory");
        }
    }
}

