/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.model.PreviewDTO;
import org.apache.james.jmap.draft.model.message.view.MessageFastView;
import org.apache.james.jmap.draft.model.message.view.SubMessage;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="propertiesFilter")
public class MessageFullView
extends MessageFastView {
    private final boolean hasAttachment;
    private final Optional<String> textBody;
    private final Optional<String> htmlBody;
    private final ImmutableList<Attachment> attachments;
    private final ImmutableMap<BlobId, SubMessage> attachedMessages;

    public static Builder builder() {
        return new Builder();
    }

    static boolean hasAttachment(List<Attachment> attachments) {
        return attachments.stream().anyMatch(attachment -> attachment.isInlinedWithCid() == false);
    }

    protected static boolean areAttachedMessagesKeysInAttachments(ImmutableList<Attachment> attachments, ImmutableMap<BlobId, SubMessage> attachedMessages) {
        return attachedMessages.isEmpty() || attachedMessages.keySet().stream().anyMatch(MessageFullView.inAttachments(attachments));
    }

    private static Predicate<BlobId> inAttachments(ImmutableList<Attachment> attachments) {
        return key -> attachments.stream().map(Attachment::getBlobId).anyMatch(blobId -> blobId.equals(key));
    }

    @VisibleForTesting
    MessageFullView(MessageId id, BlobId blobId, String threadId, ImmutableList<MailboxId> mailboxIds, Optional<String> inReplyToMessageId, boolean hasAttachment, ImmutableMap<String, String> headers, Optional<Emailer> from, ImmutableList<Emailer> to, ImmutableList<Emailer> cc, ImmutableList<Emailer> bcc, ImmutableList<Emailer> replyTo, String subject, Instant date, Number size, PreviewDTO preview, Optional<String> textBody, Optional<String> htmlBody, ImmutableList<Attachment> attachments, ImmutableMap<BlobId, SubMessage> attachedMessages, Keywords keywords) {
        super(id, blobId, threadId, mailboxIds, inReplyToMessageId, headers, from, to, cc, bcc, replyTo, subject, date, size, preview, keywords, hasAttachment);
        this.hasAttachment = hasAttachment;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
        this.attachments = attachments;
        this.attachedMessages = attachedMessages;
    }

    @Override
    public boolean isHasAttachment() {
        return this.hasAttachment;
    }

    public Optional<String> getTextBody() {
        return this.textBody;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public ImmutableList<Attachment> getAttachments() {
        return this.attachments;
    }

    public ImmutableMap<BlobId, SubMessage> getAttachedMessages() {
        return this.attachedMessages;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends MessageFastView.Builder<Builder> {
        private Optional<String> textBody = Optional.empty();
        private Optional<String> htmlBody = Optional.empty();
        private final ImmutableList.Builder<Attachment> attachments = ImmutableList.builder();
        private final ImmutableMap.Builder<BlobId, SubMessage> attachedMessages = ImmutableMap.builder();

        private Builder() {
        }

        public Builder textBody(Optional<String> textBody) {
            this.textBody = textBody;
            return this;
        }

        public Builder htmlBody(Optional<String> htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder attachments(List<Attachment> attachments) {
            this.attachments.addAll(attachments);
            boolean hasAttachments = MessageFullView.hasAttachment((List<Attachment>)this.attachments.build());
            return (Builder)super.hasAttachment(hasAttachments);
        }

        public Builder attachedMessages(Map<BlobId, SubMessage> attachedMessages) {
            this.attachedMessages.putAll(attachedMessages);
            return this;
        }

        @Override
        public MessageFullView build() {
            ImmutableList attachments = this.attachments.build();
            ImmutableMap attachedMessages = this.attachedMessages.build();
            this.checkState((ImmutableList<Attachment>)attachments, (ImmutableMap<BlobId, SubMessage>)attachedMessages);
            return new MessageFullView(this.id, this.blobId, this.threadId, (ImmutableList<MailboxId>)this.mailboxIds, Optional.ofNullable(this.inReplyToMessageId), (Boolean)this.hasAttachment.get(), (ImmutableMap<String, String>)this.headers, this.from, (ImmutableList<Emailer>)this.to.build(), (ImmutableList<Emailer>)this.cc.build(), (ImmutableList<Emailer>)this.bcc.build(), (ImmutableList<Emailer>)this.replyTo.build(), this.subject, this.date, this.size, PreviewDTO.from(this.preview), this.textBody, this.htmlBody, (ImmutableList<Attachment>)attachments, (ImmutableMap<BlobId, SubMessage>)attachedMessages, this.keywords.orElse(Keywords.DEFAULT_VALUE));
        }

        private void checkState(ImmutableList<Attachment> attachments, ImmutableMap<BlobId, SubMessage> attachedMessages) {
            super.checkState();
            Preconditions.checkState((boolean)MessageFullView.areAttachedMessagesKeysInAttachments(attachments, attachedMessages), (Object)"'attachedMessages' keys must be in 'attachements'");
        }
    }
}

