/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.api.vacation.Vacation;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.draft.json.OptionalZonedDateTimeDeserializer;
import org.apache.james.jmap.draft.json.OptionalZonedDateTimeSerializer;
import org.apache.james.util.ValuePatch;

@JsonDeserialize(builder=Builder.class)
public class VacationResponse {
    private final ValuePatch<String> id;
    private final ValuePatch<Boolean> isEnabled;
    private final ValuePatch<ZonedDateTime> fromDate;
    private final ValuePatch<ZonedDateTime> toDate;
    private final ValuePatch<String> subject;
    private final ValuePatch<String> textBody;
    private final ValuePatch<String> htmlBody;
    private final Optional<Boolean> isActivated;

    public static Builder builder() {
        return new Builder();
    }

    private VacationResponse(ValuePatch<String> id, ValuePatch<Boolean> isEnabled, ValuePatch<ZonedDateTime> fromDate, ValuePatch<ZonedDateTime> toDate, ValuePatch<String> textBody, ValuePatch<String> subject, ValuePatch<String> htmlBody, Optional<Boolean> isActivated) {
        this.id = id;
        this.isEnabled = isEnabled;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.textBody = textBody;
        this.subject = subject;
        this.htmlBody = htmlBody;
        this.isActivated = isActivated;
    }

    public String getId() {
        return (String)this.id.get();
    }

    @JsonProperty(value="isEnabled")
    public boolean isEnabled() {
        return (Boolean)this.isEnabled.get();
    }

    @JsonSerialize(using=OptionalZonedDateTimeSerializer.class)
    public Optional<ZonedDateTime> getFromDate() {
        return this.fromDate.toOptional();
    }

    @JsonSerialize(using=OptionalZonedDateTimeSerializer.class)
    public Optional<ZonedDateTime> getToDate() {
        return this.toDate.toOptional();
    }

    public Optional<String> getTextBody() {
        return this.textBody.toOptional();
    }

    public Optional<String> getSubject() {
        return this.subject.toOptional();
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody.toOptional();
    }

    @JsonIgnore
    public boolean isValid() {
        return this.isMissingOrGoodValue() && !this.isEnabled.isRemoved();
    }

    @JsonIgnore
    private boolean isMissingOrGoodValue() {
        return this.id.isKept() || this.id.toOptional().equals(Optional.of("singleton"));
    }

    @JsonIgnore
    public VacationPatch getPatch() {
        return VacationPatch.builder().fromDate(this.fromDate).toDate(this.toDate).htmlBody(this.htmlBody).textBody(this.textBody).subject(this.subject).isEnabled(this.isEnabled).build();
    }

    @JsonProperty(value="isActivated")
    public Optional<Boolean> isActivated() {
        return this.isActivated;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VacationResponse that = (VacationResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.isEnabled, that.isEnabled) && Objects.equals(this.fromDate, that.fromDate) && Objects.equals(this.toDate, that.toDate) && Objects.equals(this.textBody, that.textBody) && Objects.equals(this.subject, that.subject) && Objects.equals(this.htmlBody, that.htmlBody) && Objects.equals(this.isActivated, that.isActivated);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.isEnabled, this.fromDate, this.toDate, this.textBody, this.subject, this.htmlBody, this.isActivated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("fromDate", this.fromDate).add("toDate", this.toDate).add("isActivated", this.isActivated).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private ValuePatch<String> id = ValuePatch.keep();
        private ValuePatch<Boolean> isEnabled = ValuePatch.keep();
        private ValuePatch<ZonedDateTime> fromDate = ValuePatch.keep();
        private ValuePatch<ZonedDateTime> toDate = ValuePatch.keep();
        private ValuePatch<String> subject = ValuePatch.keep();
        private ValuePatch<String> textBody = ValuePatch.keep();
        private ValuePatch<String> htmlBody = ValuePatch.keep();
        private Optional<Boolean> isActivated = Optional.empty();

        public Builder id(String id) {
            this.id = ValuePatch.modifyTo((Object)id);
            return this;
        }

        @JsonProperty(value="isEnabled")
        public Builder enabled(boolean enabled) {
            this.isEnabled = ValuePatch.modifyTo((Object)enabled);
            return this;
        }

        @JsonProperty(value="isActivated")
        public Builder activated(Optional<Boolean> activated) {
            Preconditions.checkNotNull(activated);
            this.isActivated = activated;
            return this;
        }

        @JsonIgnore
        public Builder activated(boolean activated) {
            return this.activated(Optional.of(activated));
        }

        @JsonDeserialize(using=OptionalZonedDateTimeDeserializer.class)
        public Builder fromDate(Optional<ZonedDateTime> fromDate) {
            this.fromDate = ValuePatch.ofOptional(fromDate);
            return this;
        }

        @JsonDeserialize(using=OptionalZonedDateTimeDeserializer.class)
        public Builder toDate(Optional<ZonedDateTime> toDate) {
            this.toDate = ValuePatch.ofOptional(toDate);
            return this;
        }

        public Builder textBody(Optional<String> textBody) {
            this.textBody = ValuePatch.ofOptional(textBody);
            return this;
        }

        public Builder subject(Optional<String> subject) {
            this.subject = ValuePatch.ofOptional(subject);
            return this;
        }

        public Builder htmlBody(Optional<String> htmlBody) {
            this.htmlBody = ValuePatch.ofOptional(htmlBody);
            return this;
        }

        public Builder fromVacation(Vacation vacation) {
            this.id = ValuePatch.modifyTo((Object)"singleton");
            this.isEnabled = ValuePatch.modifyTo((Object)vacation.isEnabled());
            this.fromDate = ValuePatch.ofOptional((Optional)vacation.getFromDate());
            this.toDate = ValuePatch.ofOptional((Optional)vacation.getToDate());
            this.textBody = ValuePatch.ofOptional((Optional)vacation.getTextBody());
            this.subject = ValuePatch.ofOptional((Optional)vacation.getSubject());
            this.htmlBody = ValuePatch.ofOptional((Optional)vacation.getHtmlBody());
            return this;
        }

        public VacationResponse build() {
            return new VacationResponse(this.id, this.isEnabled, this.fromDate, this.toDate, this.textBody, this.subject, this.htmlBody, this.isActivated);
        }
    }
}

