/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.github.steveash.guavate.Guavate;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Keywords;

public class OldKeyword {
    private final Optional<Boolean> isUnread;
    private final Optional<Boolean> isFlagged;
    private final Optional<Boolean> isAnswered;
    private final Optional<Boolean> isDraft;
    private final Optional<Boolean> isForwarded;

    public static Builder builder() {
        return new Builder();
    }

    private OldKeyword(Optional<Boolean> isUnread, Optional<Boolean> isFlagged, Optional<Boolean> isAnswered, Optional<Boolean> isDraft, Optional<Boolean> isForwarded) {
        this.isUnread = isUnread;
        this.isFlagged = isFlagged;
        this.isAnswered = isAnswered;
        this.isDraft = isDraft;
        this.isForwarded = isForwarded;
    }

    public Optional<Boolean> isUnread() {
        return this.isUnread;
    }

    public Optional<Boolean> isFlagged() {
        return this.isFlagged;
    }

    public Optional<Boolean> isAnswered() {
        return this.isAnswered;
    }

    public Optional<Boolean> isDraft() {
        return this.isDraft;
    }

    public Optional<Boolean> isForwarded() {
        return this.isForwarded;
    }

    public Flags applyToState(Flags currentFlags) {
        boolean shouldMessageBeMarkSeen;
        Flags newStateFlags = new Flags();
        if (this.isFlagged().orElse(currentFlags.contains(Flags.Flag.FLAGGED)).booleanValue()) {
            newStateFlags.add(Flags.Flag.FLAGGED);
        }
        if (this.isAnswered().orElse(currentFlags.contains(Flags.Flag.ANSWERED)).booleanValue()) {
            newStateFlags.add(Flags.Flag.ANSWERED);
        }
        if (this.isDraft().orElse(currentFlags.contains(Flags.Flag.DRAFT)).booleanValue()) {
            newStateFlags.add(Flags.Flag.DRAFT);
        }
        if (this.isForwarded().orElse(currentFlags.contains(new Flags("$Forwarded"))).booleanValue()) {
            newStateFlags.add(new Flags("$Forwarded"));
        }
        if (shouldMessageBeMarkSeen = this.isUnread().map(b -> b == false).orElse(currentFlags.contains(Flags.Flag.SEEN)).booleanValue()) {
            newStateFlags.add(Flags.Flag.SEEN);
        }
        Arrays.stream(currentFlags.getUserFlags()).forEach(arg_0 -> ((Flags)newStateFlags).add(arg_0));
        if (currentFlags.contains(Flags.Flag.RECENT)) {
            newStateFlags.add(Flags.Flag.RECENT);
        }
        if (currentFlags.contains(Flags.Flag.DELETED)) {
            newStateFlags.add(Flags.Flag.DELETED);
        }
        return newStateFlags;
    }

    public Keywords asKeywords() {
        return Keywords.strictFactory().fromSet((Set)Stream.of(this.isAnswered.filter(b -> b).map(b -> Keyword.ANSWERED), this.isDraft.filter(b -> b).map(b -> Keyword.DRAFT), this.isForwarded.filter(b -> b).map(b -> Keyword.FORWARDED), this.isFlagged.filter(b -> b).map(b -> Keyword.FLAGGED), this.isUnread.filter(b -> b == false).map(b -> Keyword.SEEN)).flatMap(Optional::stream).collect(Guavate.toImmutableSet()));
    }

    public final boolean equals(Object other) {
        if (other instanceof OldKeyword) {
            OldKeyword oldKeyword = (OldKeyword)other;
            return Objects.equal(this.isUnread, oldKeyword.isUnread) && Objects.equal(this.isFlagged, oldKeyword.isFlagged) && Objects.equal(this.isAnswered, oldKeyword.isAnswered) && Objects.equal(this.isDraft, oldKeyword.isDraft) && Objects.equal(this.isForwarded, oldKeyword.isForwarded);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isUnread, this.isFlagged, this.isAnswered, this.isDraft, this.isForwarded});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isUnread", this.isUnread).add("isFlagged", this.isFlagged).add("isAnswered", this.isAnswered).add("isDraft", this.isDraft).add("isForwarded", this.isForwarded).toString();
    }

    public static class Builder {
        private Optional<Boolean> isUnread = Optional.empty();
        private Optional<Boolean> isFlagged = Optional.empty();
        private Optional<Boolean> isAnswered = Optional.empty();
        private Optional<Boolean> isDraft = Optional.empty();
        private Optional<Boolean> isForwarded = Optional.empty();

        private Builder() {
        }

        public Builder isFlagged(Optional<Boolean> isFlagged) {
            this.isFlagged = isFlagged;
            return this;
        }

        public Builder isFlagged(boolean isFlagged) {
            return this.isFlagged(Optional.of(isFlagged));
        }

        public Builder isUnread(Optional<Boolean> isUnread) {
            this.isUnread = isUnread;
            return this;
        }

        public Builder isUnread(boolean isUnread) {
            return this.isUnread(Optional.of(isUnread));
        }

        public Builder isAnswered(Optional<Boolean> isAnswered) {
            this.isAnswered = isAnswered;
            return this;
        }

        public Builder isAnswered(boolean isAnswered) {
            return this.isAnswered(Optional.of(isAnswered));
        }

        public Builder isDraft(Optional<Boolean> isDraft) {
            this.isDraft = isDraft;
            return this;
        }

        public Builder isDraft(boolean isDraft) {
            return this.isDraft(Optional.of(isDraft));
        }

        public Builder isForwarded(Optional<Boolean> isForwarded) {
            this.isForwarded = isForwarded;
            return this;
        }

        public Builder isForwarded(boolean isForwarded) {
            return this.isForwarded(Optional.of(isForwarded));
        }

        public Optional<OldKeyword> computeOldKeyword() {
            if (this.isAnswered.isPresent() || this.isFlagged.isPresent() || this.isUnread.isPresent() || this.isForwarded.isPresent() || this.isDraft.isPresent()) {
                return Optional.of(new OldKeyword(this.isUnread, this.isFlagged, this.isAnswered, this.isDraft, this.isForwarded));
            }
            return Optional.empty();
        }
    }
}

