/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.mailbox.model.ContentType;

@JsonDeserialize(builder=Builder.class)
public class Attachment {
    private final BlobId blobId;
    private final ContentType type;
    private final Optional<String> name;
    private final Number size;
    private final Optional<String> cid;
    private final boolean isInline;
    private final Optional<Number> width;
    private final Optional<Number> height;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    Attachment(BlobId blobId, ContentType type, Optional<String> name, Number size, Optional<String> cid, boolean isInline, Optional<Number> width, Optional<Number> height) {
        this.blobId = blobId;
        this.type = type;
        this.name = name;
        this.size = size;
        this.cid = cid;
        this.isInline = isInline;
        this.width = width;
        this.height = height;
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public ContentType getType() {
        return this.type;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Number getSize() {
        return this.size;
    }

    public Optional<String> getCid() {
        return this.cid;
    }

    public boolean isIsInline() {
        return this.isInline;
    }

    public Boolean isInlinedWithCid() {
        return this.isInline && this.cid.isPresent();
    }

    public Optional<Number> getWidth() {
        return this.width;
    }

    public Optional<Number> getHeight() {
        return this.height;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attachment) {
            Attachment other = (Attachment)obj;
            return Objects.equals(this.blobId, other.blobId) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.size, other.size) && Objects.equals(this.cid, other.cid) && Objects.equals(this.isInline, other.isInline) && Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.blobId, this.type, this.name, this.size, this.cid, this.isInline, this.width, this.height);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blobId", (Object)this.blobId).add("type", (Object)this.type).add("name", this.name).add("size", (Object)this.size).add("cid", this.cid).add("isInline", this.isInline).add("width", this.width).add("height", this.height).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private BlobId blobId;
        private ContentType type;
        private String name;
        private Number size;
        private String cid;
        private boolean isInline;
        private Number width;
        private Number height;

        public Builder blobId(BlobId blobId) {
            this.blobId = blobId;
            return this;
        }

        @JsonDeserialize
        public Builder type(String type) {
            this.type = ContentType.of((String)type);
            return this;
        }

        public Builder type(ContentType type) {
            this.type = type;
            return this;
        }

        @JsonDeserialize
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public Builder size(long size) {
            this.size = Number.DEFAULT_FACTORY.from(size).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53"));
            return this;
        }

        @JsonDeserialize
        public Builder cid(String cid) {
            this.cid = cid;
            return this;
        }

        public Builder cid(Optional<String> cid) {
            this.cid = cid.orElse(null);
            return this;
        }

        public Builder isInline(boolean isInline) {
            this.isInline = isInline;
            return this;
        }

        public Builder width(long width) {
            this.width = Number.DEFAULT_FACTORY.from(width).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53"));
            return this;
        }

        public Builder height(long height) {
            this.height = Number.DEFAULT_FACTORY.from(height).orElseThrow(() -> new IllegalArgumentException("value should be positive and less than 2^53"));
            return this;
        }

        public Attachment build() {
            Preconditions.checkState((this.blobId != null ? 1 : 0) != 0, (Object)"'blobId' is mandatory");
            Preconditions.checkState((this.size != null ? 1 : 0) != 0, (Object)"'size' is mandatory");
            return new Attachment(this.blobId, this.type, Optional.ofNullable(this.name), this.size, Optional.ofNullable(this.cid), this.isInline, Optional.ofNullable(this.width), Optional.ofNullable(this.height));
        }
    }
}

