/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.SetMessagesCreationProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.DeleteResult;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMessagesDestructionProcessor
implements SetMessagesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMessagesCreationProcessor.class);
    private final MessageIdManager messageIdManager;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    SetMessagesDestructionProcessor(MessageIdManager messageIdManager, MetricFactory metricFactory) {
        this.messageIdManager = messageIdManager;
        this.metricFactory = metricFactory;
    }

    @Override
    public SetMessagesResponse process(SetMessagesRequest request, MailboxSession mailboxSession) {
        return (SetMessagesResponse)this.metricFactory.decorateSupplierWithTimerMetric("JMAP-SetMessageDestructionProcessor", () -> this.delete(request.getDestroy(), mailboxSession).reduce(SetMessagesResponse.builder(), SetMessagesResponse.Builder::accumulator, SetMessagesResponse.Builder::combiner).build());
    }

    private Stream<SetMessagesResponse> delete(List<MessageId> toBeDestroyed, MailboxSession mailboxSession) {
        try {
            if (toBeDestroyed.isEmpty()) {
                return Stream.empty();
            }
            DeleteResult deleteResult = this.messageIdManager.delete(toBeDestroyed, mailboxSession);
            Stream<SetMessagesResponse> destroyed = deleteResult.getDestroyed().stream().map(messageId -> SetMessagesResponse.builder().destroyed((MessageId)messageId).build());
            Stream<SetMessagesResponse> notFound = deleteResult.getNotFound().stream().map(messageId -> SetMessagesResponse.builder().notDestroyed((MessageId)messageId, SetError.builder().type(SetError.Type.NOT_FOUND).description("The message " + messageId.serialize() + " can't be found").build()).build());
            return Stream.concat(destroyed, notFound);
        }
        catch (MailboxException e) {
            LOGGER.error("An error occurred when deleting a message", (Throwable)e);
            return toBeDestroyed.stream().map(messageId -> SetMessagesResponse.builder().notDestroyed((MessageId)messageId, SetError.builder().type(SetError.Type.ERROR).description("An error occurred while deleting messages " + messageId.serialize()).build()).build());
        }
    }
}

