/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.jmap.draft.exceptions.MailboxHasChildException;
import org.apache.james.jmap.draft.exceptions.SystemMailboxNotUpdatableException;
import org.apache.james.jmap.draft.methods.SetMailboxesProcessor;
import org.apache.james.jmap.draft.model.MailboxFactory;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMailboxesRequest;
import org.apache.james.jmap.draft.model.SetMailboxesResponse;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;
import org.apache.james.jmap.draft.utils.MailboxUtils;
import org.apache.james.jmap.draft.utils.SortingHierarchicalCollections;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMailboxesDestructionProcessor
implements SetMailboxesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMailboxesDestructionProcessor.class);
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final SortingHierarchicalCollections<Map.Entry<MailboxId, Mailbox>, MailboxId> sortingHierarchicalCollections;
    private final MailboxUtils mailboxUtils;
    private final MailboxFactory mailboxFactory;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    SetMailboxesDestructionProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxUtils mailboxUtils, MailboxFactory mailboxFactory, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.metricFactory = metricFactory;
        this.sortingHierarchicalCollections = new SortingHierarchicalCollections<Map.Entry, MailboxId>(Map.Entry::getKey, x -> ((Mailbox)x.getValue()).getParentId());
        this.mailboxUtils = mailboxUtils;
        this.mailboxFactory = mailboxFactory;
    }

    @Override
    public SetMailboxesResponse process(SetMailboxesRequest request, MailboxSession mailboxSession) {
        TimeMetric timeMetric = this.metricFactory.timer("JMAP-SetMailboxesDestructionProcessor");
        ImmutableMap<MailboxId, Mailbox> idToMailbox = this.mapDestroyRequests(request, mailboxSession);
        SetMailboxesResponse.Builder builder = SetMailboxesResponse.builder();
        this.sortingHierarchicalCollections.sortFromLeafToRoot((Collection<Map.Entry<MailboxId, Mailbox>>)idToMailbox.entrySet()).forEach(entry -> this.destroyMailbox((Map.Entry<MailboxId, Mailbox>)entry, mailboxSession, builder));
        this.notDestroyedRequests(request, idToMailbox, builder);
        timeMetric.stopAndPublish();
        return builder.build();
    }

    private ImmutableMap<MailboxId, Mailbox> mapDestroyRequests(SetMailboxesRequest request, MailboxSession mailboxSession) {
        ImmutableMap.Builder idToMailboxBuilder = ImmutableMap.builder();
        request.getDestroy().stream().map(id -> this.mailboxFactory.builder().id((MailboxId)id).session(mailboxSession).build()).flatMap(Optional::stream).forEach(mailbox -> idToMailboxBuilder.put((Object)mailbox.getId(), mailbox));
        return idToMailboxBuilder.build();
    }

    private void notDestroyedRequests(SetMailboxesRequest request, ImmutableMap<MailboxId, Mailbox> idToMailbox, SetMailboxesResponse.Builder builder) {
        request.getDestroy().stream().filter(id -> !idToMailbox.containsKey(id)).forEach(id -> this.notDestroy((MailboxId)id, builder));
    }

    private void destroyMailbox(Map.Entry<MailboxId, Mailbox> entry, MailboxSession mailboxSession, SetMailboxesResponse.Builder builder) {
        try {
            Mailbox mailbox = entry.getValue();
            this.preconditions(mailbox, mailboxSession);
            MailboxPath deletedMailbox = this.mailboxManager.deleteMailbox(mailbox.getId(), mailboxSession).generateAssociatedPath();
            this.subscriptionManager.unsubscribe(mailboxSession, deletedMailbox.getName());
            builder.destroyed(entry.getKey());
        }
        catch (MailboxHasChildException e) {
            builder.notDestroyed(entry.getKey(), SetError.builder().type(SetError.Type.MAILBOX_HAS_CHILD).description(String.format("The mailbox '%s' has a child.", entry.getKey().serialize())).build());
        }
        catch (SystemMailboxNotUpdatableException e) {
            builder.notDestroyed(entry.getKey(), SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description(String.format("The mailbox '%s' is a system mailbox.", entry.getKey().serialize())).build());
        }
        catch (TooLongMailboxNameException e) {
            builder.notDestroyed(entry.getKey(), SetError.builder().type(SetError.Type.INVALID_ARGUMENTS).description("The mailbox name length is too long").build());
        }
        catch (MailboxException e) {
            String message = String.format("An error occurred when deleting the mailbox '%s'", entry.getKey().serialize());
            LOGGER.error(message, (Throwable)e);
            builder.notDestroyed(entry.getKey(), SetError.builder().type(SetError.Type.ERROR).description(message).build());
        }
    }

    private void preconditions(Mailbox mailbox, MailboxSession mailboxSession) throws MailboxHasChildException, SystemMailboxNotUpdatableException, MailboxException {
        this.checkForChild(mailbox.getId(), mailboxSession);
        this.checkRole(mailbox.getRole());
    }

    private void checkForChild(MailboxId id, MailboxSession mailboxSession) throws MailboxHasChildException, MailboxException {
        if (this.mailboxUtils.hasChildren(id, mailboxSession)) {
            throw new MailboxHasChildException();
        }
    }

    private void checkRole(Optional<Role> role) throws SystemMailboxNotUpdatableException {
        if (role.map(Role::isSystemRole).orElse(false).booleanValue()) {
            throw new SystemMailboxNotUpdatableException();
        }
    }

    private void notDestroy(MailboxId id, SetMailboxesResponse.Builder builder) {
        builder.notDestroyed(id, SetError.builder().type(SetError.Type.NOT_FOUND).description(String.format("The mailbox '%s' was not found.", id.serialize())).build());
    }
}

