/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class ReferenceUpdater {
    public static final String X_FORWARDED_ID_HEADER = "X-Forwarded-Message-Id";
    public static final Flags FORWARDED_FLAG = new Flags("$Forwarded");
    private static final Logger logger = LoggerFactory.getLogger(ReferenceUpdater.class);
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;

    @Inject
    public ReferenceUpdater(MessageIdManager messageIdManager, MailboxManager mailboxManager) {
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
    }

    public void updateReferences(Headers headers, MailboxSession session) throws MailboxException {
        Map headersAsMap = (Map)Iterators.toStream((Iterator)headers.headers()).collect(Guavate.toImmutableMap(Header::getName, Header::getValue));
        this.updateReferences(headersAsMap, session);
    }

    public void updateReferences(Map<String, String> headers, MailboxSession session) throws MailboxException {
        Optional<String> inReplyToId = Optional.ofNullable(headers.get("In-Reply-To"));
        Optional<String> forwardedId = Optional.ofNullable(headers.get(X_FORWARDED_ID_HEADER));
        inReplyToId.ifPresent(Throwing.consumer(id -> this.updateAnswered((String)id, session)).sneakyThrow());
        forwardedId.ifPresent(Throwing.consumer(id -> this.updateForwarded((String)id, session)).sneakyThrow());
    }

    private void updateAnswered(String messageId, MailboxSession session) throws MailboxException {
        this.updateFlag(messageId, session, new Flags(Flags.Flag.ANSWERED));
    }

    private void updateForwarded(String messageId, MailboxSession session) throws MailboxException {
        this.updateFlag(messageId, session, FORWARDED_FLAG);
    }

    private void updateFlag(String messageId, MailboxSession session, Flags flag) throws MailboxException {
        int limit = 2;
        MultimailboxesSearchQuery searchByRFC822MessageId = MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mimeMessageID((String)messageId)})).build();
        List references = (List)Flux.from((Publisher)this.mailboxManager.search(searchByRFC822MessageId, session, (long)limit)).collectList().block();
        try {
            MessageId reference = (MessageId)Iterables.getOnlyElement((Iterable)references);
            List mailboxIds = (List)Flux.from((Publisher)this.messageIdManager.messageMetadata(reference, session)).map(metaData -> metaData.getComposedMessageId().getMailboxId()).collect(Guavate.toImmutableList()).block();
            this.messageIdManager.setFlags(flag, MessageManager.FlagsUpdateMode.ADD, reference, mailboxIds, session);
        }
        catch (NoSuchElementException e) {
            logger.info("Unable to find a message with this Mime Message Id: " + messageId);
        }
        catch (IllegalArgumentException e) {
            logger.info("Too many messages are matching this Mime Message Id: " + messageId);
        }
    }
}

