/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.james.jmap.draft.methods.MIMEMessageConverter;
import org.apache.james.jmap.draft.methods.ValueWithId;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.CreationMessage;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.util.OptionalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageAppender.class);
    private final MailboxManager mailboxManager;
    private final MessageIdManager messageIdManager;
    private final AttachmentManager attachmentManager;
    private final MIMEMessageConverter mimeMessageConverter;

    @Inject
    public MessageAppender(MailboxManager mailboxManager, MessageIdManager messageIdManager, AttachmentManager attachmentManager, MIMEMessageConverter mimeMessageConverter) {
        this.mailboxManager = mailboxManager;
        this.messageIdManager = messageIdManager;
        this.attachmentManager = attachmentManager;
        this.mimeMessageConverter = mimeMessageConverter;
    }

    public MessageFullViewFactory.MetaDataWithContent appendMessageInMailboxes(ValueWithId.CreationMessageEntry createdEntry, List<MailboxId> targetMailboxes, MailboxSession session) throws MailboxException {
        Preconditions.checkArgument((!targetMailboxes.isEmpty() ? 1 : 0) != 0);
        ImmutableList<MessageAttachmentMetadata> messageAttachments = this.getMessageAttachments(session, ((CreationMessage)createdEntry.getValue()).getAttachments());
        byte[] messageContent = this.mimeMessageConverter.convert(createdEntry, messageAttachments, session);
        Date internalDate = Date.from(((CreationMessage)createdEntry.getValue()).getDate().toInstant());
        MessageManager mailbox = this.mailboxManager.getMailbox(targetMailboxes.get(0), session);
        MessageManager.AppendResult appendResult = mailbox.appendMessage(MessageManager.AppendCommand.builder().withInternalDate(internalDate).withFlags(this.getFlags((CreationMessage)createdEntry.getValue())).notRecent().build((Content)new ByteContent(messageContent)), session);
        ComposedMessageId ids = appendResult.getId();
        if (targetMailboxes.size() > 1) {
            this.messageIdManager.setInMailboxes(ids.getMessageId(), targetMailboxes, session);
        }
        return MessageFullViewFactory.MetaDataWithContent.builder().uid(ids.getUid()).keywords(((CreationMessage)createdEntry.getValue()).getKeywords()).internalDate(internalDate.toInstant()).sharedContent((SharedInputStream)new SharedByteArrayInputStream(messageContent)).size(messageContent.length).attachments(appendResult.getMessageAttachments()).mailboxId(mailbox.getId()).messageId(ids.getMessageId()).build();
    }

    public MessageFullViewFactory.MetaDataWithContent appendMessageInMailbox(Message message, MessageManager messageManager, Flags flags, MailboxSession session) throws MailboxException {
        byte[] messageContent = this.asBytes(message);
        Date internalDate = new Date();
        MessageManager.AppendResult appendResult = messageManager.appendMessage(MessageManager.AppendCommand.builder().withFlags(flags).build((Content)new ByteContent(messageContent)), session);
        ComposedMessageId ids = appendResult.getId();
        return MessageFullViewFactory.MetaDataWithContent.builder().uid(ids.getUid()).keywords(Keywords.lenientFactory().fromFlags(flags)).internalDate(internalDate.toInstant()).sharedContent((SharedInputStream)new SharedByteArrayInputStream(messageContent)).size(messageContent.length).attachments(appendResult.getMessageAttachments()).mailboxId(messageManager.getId()).messageId(ids.getMessageId()).build();
    }

    public byte[] asBytes(Message message) throws MailboxException {
        try {
            return DefaultMessageWriter.asBytes((Message)message);
        }
        catch (IOException e) {
            throw new MailboxException("Could not write message as bytes", (Throwable)e);
        }
    }

    private Flags getFlags(CreationMessage message) {
        return message.getKeywords().asFlags();
    }

    private ImmutableList<MessageAttachmentMetadata> getMessageAttachments(MailboxSession session, ImmutableList<Attachment> attachments) throws MailboxException {
        Map attachmentsById = (Map)this.attachmentManager.getAttachments((List)attachments.stream().map(attachment -> AttachmentId.from((String)attachment.getBlobId().getRawValue())).collect(Guavate.toImmutableList()), session).stream().collect(Guavate.toImmutableMap(AttachmentMetadata::getAttachmentId));
        ThrowingFunction toMessageAttachment = att -> this.messageAttachment((Attachment)att, attachmentsById);
        return (ImmutableList)attachments.stream().map(Throwing.function((ThrowingFunction)toMessageAttachment).sneakyThrow()).flatMap(Optional::stream).collect(Guavate.toImmutableList());
    }

    private Optional<MessageAttachmentMetadata> messageAttachment(Attachment attachment, Map<AttachmentId, AttachmentMetadata> attachmentsById) throws MailboxException {
        try {
            AttachmentId attachmentId = AttachmentId.from((String)attachment.getBlobId().getRawValue());
            return OptionalUtils.executeIfEmpty(Optional.ofNullable(attachmentsById.get(attachmentId)).map(attachmentMetadata -> MessageAttachmentMetadata.builder().attachment(attachmentMetadata).name((String)attachment.getName().orElse(null)).cid((Cid)attachment.getCid().map(Cid::from).orElse(null)).isInline(Boolean.valueOf(attachment.isIsInline())).build()), () -> LOGGER.error(String.format("Attachment %s not found", attachment.getBlobId())));
        }
        catch (IllegalStateException e) {
            LOGGER.error(String.format("Attachment %s is not well-formed", attachment.getBlobId()), (Throwable)e);
            return Optional.empty();
        }
    }
}

