/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.apache.james.jmap.draft.methods.ErrorResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.Property;

public class JmapResponse {
    private final Method.Response.Name method;
    private final MethodCallId methodCallId;
    private final Method.Response response;
    private final Optional<? extends Set<? extends Property>> properties;
    private final Optional<SimpleFilterProvider> filterProvider;

    public static Builder builder() {
        return new Builder();
    }

    private JmapResponse(Method.Response.Name method, MethodCallId methodCallId, Method.Response response, Optional<? extends Set<? extends Property>> properties, Optional<SimpleFilterProvider> filterProvider) {
        this.method = method;
        this.methodCallId = methodCallId;
        this.response = response;
        this.properties = properties;
        this.filterProvider = filterProvider;
    }

    public Method.Response.Name getResponseName() {
        return this.method;
    }

    public Method.Response getResponse() {
        return this.response;
    }

    public MethodCallId getMethodCallId() {
        return this.methodCallId;
    }

    public Optional<? extends Set<? extends Property>> getProperties() {
        return this.properties;
    }

    public Optional<SimpleFilterProvider> getFilterProvider() {
        return this.filterProvider;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.method, this.methodCallId, this.response, this.properties, this.filterProvider});
    }

    public boolean equals(Object object) {
        if (object instanceof JmapResponse) {
            JmapResponse that = (JmapResponse)object;
            return Objects.equal((Object)this.method, (Object)that.method) && Objects.equal((Object)this.methodCallId, (Object)that.methodCallId) && Objects.equal((Object)this.response, (Object)that.response) && Objects.equal(this.properties, that.properties) && Objects.equal(this.filterProvider, that.filterProvider);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("method", (Object)this.method).add("response", (Object)this.response).add("methodCallId", (Object)this.methodCallId).add("properties", this.properties).add("filterProvider", this.filterProvider).toString();
    }

    public static class Builder {
        private Method.Response.Name responseName;
        private MethodCallId methodCallId;
        private Method.Response response;
        private Optional<? extends Set<? extends Property>> properties = Optional.empty();
        private Optional<SimpleFilterProvider> filterProvider = Optional.empty();

        private Builder() {
        }

        public Builder responseName(Method.Response.Name name) {
            this.responseName = name;
            return this;
        }

        public Builder methodCallId(MethodCallId methodCallId) {
            this.methodCallId = methodCallId;
            return this;
        }

        public Builder response(Method.Response response) {
            this.response = response;
            return this;
        }

        public Builder properties(Optional<? extends Set<? extends Property>> properties) {
            this.properties = properties.map(ImmutableSet::copyOf);
            return this;
        }

        public Builder properties(Set<? extends Property> properties) {
            return this.properties(Optional.ofNullable(properties));
        }

        public Builder filterProvider(Optional<SimpleFilterProvider> filterProvider) {
            this.filterProvider = filterProvider;
            return this;
        }

        public Builder error() {
            this.response = ErrorResponse.builder().build();
            this.responseName = ErrorResponse.ERROR_METHOD;
            return this;
        }

        public Builder error(ErrorResponse error) {
            this.response = error;
            this.responseName = ErrorResponse.ERROR_METHOD;
            return this;
        }

        public JmapResponse build() {
            Preconditions.checkState((this.methodCallId != null ? 1 : 0) != 0, (Object)"'methodCallId' needs to be specified");
            Preconditions.checkState((this.responseName != null ? 1 : 0) != 0, (Object)"'responseName' needs to be specified");
            return new JmapResponse(this.responseName, this.methodCallId, this.response, this.properties, this.filterProvider);
        }
    }
}

