/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.GetMailboxesRequest;
import org.apache.james.jmap.draft.model.GetMailboxesResponse;
import org.apache.james.jmap.draft.model.MailboxFactory;
import org.apache.james.jmap.draft.model.MailboxProperty;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.mailbox.Mailbox;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoader;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoaderWithDefaultPreloaded;
import org.apache.james.jmap.http.DefaultMailboxesProvisioner;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class GetMailboxesMethod
implements Method {
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("getMailboxes");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("mailboxes");
    private static final Optional<List<MailboxMetaData>> NO_PRELOADED_METADATA = Optional.empty();
    private static final String ACTION = "GET_MAILBOXES";
    private final MailboxManager mailboxManager;
    private final MailboxFactory mailboxFactory;
    private final MetricFactory metricFactory;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;
    private final DefaultMailboxesProvisioner provisioner;

    @Inject
    @VisibleForTesting
    public GetMailboxesMethod(MailboxManager mailboxManager, QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MailboxFactory mailboxFactory, MetricFactory metricFactory, DefaultMailboxesProvisioner provisioner) {
        this.mailboxManager = mailboxManager;
        this.mailboxFactory = mailboxFactory;
        this.metricFactory = metricFactory;
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
        this.provisioner = provisioner;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return GetMailboxesRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkArgument((boolean)(request instanceof GetMailboxesRequest));
        GetMailboxesRequest mailboxesRequest = (GetMailboxesRequest)request;
        return (Flux)this.metricFactory.decorateSupplierWithTimerMetricLogP99("JMAP-" + METHOD_NAME.getName(), () -> this.process(methodCallId, mailboxSession, mailboxesRequest).subscriberContext(ReactorUtils.context((String)ACTION, (MDCBuilder)this.mdc(mailboxesRequest))));
    }

    private MDCBuilder mdc(GetMailboxesRequest mailboxesRequest) {
        return MDCBuilder.create().addContext("action", (Object)ACTION).addContext("accountId", mailboxesRequest.getAccountId()).addContext("mailboxIds", mailboxesRequest.getIds()).addContext("properties", mailboxesRequest.getProperties());
    }

    private Flux<JmapResponse> process(MethodCallId methodCallId, MailboxSession mailboxSession, GetMailboxesRequest mailboxesRequest) {
        return this.provisioner.createMailboxesIfNeeded(mailboxSession).thenMany((Publisher)Flux.from((Publisher)this.getMailboxesResponse(mailboxesRequest, mailboxSession).map(response -> JmapResponse.builder().methodCallId(methodCallId).response((Method.Response)response).properties(mailboxesRequest.getProperties().map(this::ensureContainsId)).responseName(RESPONSE_NAME).build())));
    }

    private Set<MailboxProperty> ensureContainsId(Set<MailboxProperty> input) {
        return Sets.union(input, (Set)ImmutableSet.of((Object)MailboxProperty.ID)).immutableCopy();
    }

    private Mono<GetMailboxesResponse> getMailboxesResponse(GetMailboxesRequest mailboxesRequest, MailboxSession mailboxSession) {
        Optional<ImmutableList<MailboxId>> mailboxIds = mailboxesRequest.getIds();
        return this.retrieveMailboxes(mailboxIds, mailboxSession).sort(Comparator.comparing(Mailbox::getSortOrder)).reduce((Object)GetMailboxesResponse.builder(), GetMailboxesResponse.Builder::add).map(GetMailboxesResponse.Builder::build);
    }

    private Flux<Mailbox> retrieveMailboxes(Optional<ImmutableList<MailboxId>> mailboxIds, MailboxSession mailboxSession) {
        return mailboxIds.map(ids -> this.retrieveSpecificMailboxes(mailboxSession, (ImmutableList<MailboxId>)ids)).orElseGet(Throwing.supplier(() -> this.retrieveAllMailboxes(mailboxSession)).sneakyThrow());
    }

    private Flux<Mailbox> retrieveSpecificMailboxes(MailboxSession mailboxSession, ImmutableList<MailboxId> mailboxIds) {
        return Flux.fromIterable(mailboxIds).flatMap(mailboxId -> Mono.fromCallable(() -> this.mailboxFactory.builder().id((MailboxId)mailboxId).session(mailboxSession).usingPreloadedMailboxesMetadata(NO_PRELOADED_METADATA).build()).subscribeOn(Schedulers.elastic()), 16).handle(ReactorUtils.publishIfPresent());
    }

    private Flux<Mailbox> retrieveAllMailboxes(MailboxSession mailboxSession) {
        Mono userMailboxesMono = this.getAllMailboxesMetaData(mailboxSession).collectList();
        Mono quotaLoaderMono = Mono.fromCallable(() -> new QuotaLoaderWithDefaultPreloaded(this.quotaRootResolver, this.quotaManager, mailboxSession)).subscribeOn(Schedulers.elastic());
        return userMailboxesMono.zipWith(quotaLoaderMono).flatMapMany(tuple -> Flux.fromIterable((Iterable)((Iterable)tuple.getT1())).map(mailboxMetaData -> this.mailboxFactory.builder().mailboxMetadata((MailboxMetaData)mailboxMetaData).session(mailboxSession).usingPreloadedMailboxesMetadata(Optional.of((List)tuple.getT1())).quotaLoader((QuotaLoader)tuple.getT2()).build()).handle(ReactorUtils.publishIfPresent()));
    }

    private Flux<MailboxMetaData> getAllMailboxesMetaData(MailboxSession mailboxSession) {
        return this.mailboxManager.search(MailboxQuery.builder().matchesAllMailboxNames().build(), mailboxSession);
    }
}

