/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Swagger;
import javax.inject.Inject;
import org.apache.james.util.Port;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@SwaggerDefinition
public class SwaggerParser {
    private static final String[] SCHEMES = new String[]{SwaggerDefinition.Scheme.HTTP.name(), SwaggerDefinition.Scheme.HTTPS.name()};
    private static final String JSON_TYPE = "application/json";
    private static final String API_DOC_VERSION = "V1.0";
    private static final String API_DOC_TITLE = "JAMES Web Admin API";
    private static final String API_DOC_DESCRIPTION = "All the web administration API for JAMES";
    public static final String HOST_PORT_SEPARATOR = ":";

    @Inject
    public static String getSwaggerJson(String packageName, WebAdminConfiguration configuration) throws JsonProcessingException {
        return SwaggerParser.swaggerToJson(SwaggerParser.getSwagger(packageName, configuration));
    }

    private static Swagger getSwagger(String packageName, WebAdminConfiguration configuration) {
        return new Reader(SwaggerParser.getSwagger(SwaggerParser.getBeanConfig(packageName, configuration))).read(new Reflections(packageName, new Scanner[0]).getTypesAnnotatedWith(Api.class));
    }

    private static Swagger getSwagger(BeanConfig beanConfig) {
        Swagger swagger = beanConfig.getSwagger();
        swagger.addConsumes(JSON_TYPE);
        swagger.addProduces(JSON_TYPE);
        return swagger;
    }

    private static BeanConfig getBeanConfig(String packageName, WebAdminConfiguration configuration) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(packageName);
        beanConfig.setVersion(API_DOC_VERSION);
        beanConfig.setTitle(API_DOC_TITLE);
        beanConfig.setDescription(API_DOC_DESCRIPTION);
        beanConfig.setHost(configuration.getHost() + HOST_PORT_SEPARATOR + ((Port)configuration.getPort().get()).getValue());
        beanConfig.setSchemes(SCHEMES);
        beanConfig.setScan(true);
        beanConfig.scanAndRead();
        return beanConfig;
    }

    public static String swaggerToJson(Swagger swagger) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return objectMapper.writeValueAsString((Object)swagger);
    }
}

