/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoAPI;
import org.apache.james.mailrepository.cassandra.MailRepositoryTableV2;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import reactor.core.publisher.Mono;

public class CassandraMailRepositoryMailDaoV2
implements CassandraMailRepositoryMailDaoAPI {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertMail;
    private final PreparedStatement deleteMail;
    private final PreparedStatement selectMail;
    private final BlobId.Factory blobIdFactory;
    private final TupleType userHeaderNameHeaderValueTriple;

    @Inject
    @VisibleForTesting
    CassandraMailRepositoryMailDaoV2(Session session, BlobId.Factory blobIdFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertMail = this.prepareInsert(session);
        this.deleteMail = this.prepareDelete(session);
        this.selectMail = this.prepareSelect(session);
        this.blobIdFactory = blobIdFactory;
        this.userHeaderNameHeaderValueTriple = session.getCluster().getMetadata().newTupleType(new DataType[]{DataType.text(), DataType.text(), DataType.text()});
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailRepositoryContentV2").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).and(QueryBuilder.eq((String)"mailKey", (Object)QueryBuilder.bindMarker((String)"mailKey"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailRepositoryContentV2").value("name", (Object)QueryBuilder.bindMarker((String)"name")).value("mailKey", (Object)QueryBuilder.bindMarker((String)"mailKey")).value("state", (Object)QueryBuilder.bindMarker((String)"state")).value("sender", (Object)QueryBuilder.bindMarker((String)"sender")).value("recipients", (Object)QueryBuilder.bindMarker((String)"recipients")).value("attributes", (Object)QueryBuilder.bindMarker((String)"attributes")).value("errorMessage", (Object)QueryBuilder.bindMarker((String)"errorMessage")).value("remoteAddr", (Object)QueryBuilder.bindMarker((String)"remoteAddr")).value("remoteHost", (Object)QueryBuilder.bindMarker((String)"remoteHost")).value("lastUpdated", (Object)QueryBuilder.bindMarker((String)"lastUpdated")).value("headerBlobId", (Object)QueryBuilder.bindMarker((String)"headerBlobId")).value("bodyBlobId", (Object)QueryBuilder.bindMarker((String)"bodyBlobId")).value("perRecipientSpecificHeaders", (Object)QueryBuilder.bindMarker((String)"perRecipientSpecificHeaders")));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])MailRepositoryTableV2.MAIL_PROPERTIES).from("mailRepositoryContentV2").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).and(QueryBuilder.eq((String)"mailKey", (Object)QueryBuilder.bindMarker((String)"mailKey"))));
    }

    @Override
    public Mono<Void> store(MailRepositoryUrl url, Mail mail, BlobId headerId, BlobId bodyId) {
        return Mono.fromCallable(() -> {
            BoundStatement boundStatement = this.insertMail.bind().setString("name", url.asString()).setString("mailKey", mail.getName()).setString("headerBlobId", headerId.asString()).setString("bodyBlobId", bodyId.asString()).setString("state", mail.getState()).setList("recipients", this.asStringList(mail.getRecipients())).setString("remoteAddr", mail.getRemoteAddr()).setString("remoteHost", mail.getRemoteHost()).setTimestamp("lastUpdated", mail.getLastUpdated()).setMap("attributes", this.toRawAttributeMap(mail)).setList("perRecipientSpecificHeaders", this.toTupleList(mail.getPerRecipientSpecificHeaders()));
            Optional.ofNullable(mail.getErrorMessage()).ifPresent(errorMessage -> boundStatement.setString("errorMessage", mail.getErrorMessage()));
            mail.getMaybeSender().asOptional().map(MailAddress::asString).ifPresent(mailAddress -> boundStatement.setString("sender", mailAddress));
            return boundStatement;
        }).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.executor).executeVoid(arg_0));
    }

    @Override
    public Mono<Void> remove(MailRepositoryUrl url, MailKey key) {
        return this.executor.executeVoid((Statement)this.deleteMail.bind().setString("name", url.asString()).setString("mailKey", key.asString()));
    }

    @Override
    public Mono<Optional<CassandraMailRepositoryMailDaoAPI.MailDTO>> read(MailRepositoryUrl url, MailKey key) {
        return this.executor.executeSingleRowOptional((Statement)this.selectMail.bind().setString("name", url.asString()).setString("mailKey", key.asString())).map(rowOptional -> rowOptional.map(this::toMail));
    }

    private CassandraMailRepositoryMailDaoAPI.MailDTO toMail(Row row) {
        MaybeSender sender = MaybeSender.getMailSender((String)row.getString("sender"));
        List recipients = (List)row.getList("recipients", String.class).stream().map(Throwing.function(MailAddress::new)).collect(Guavate.toImmutableList());
        String state = row.getString("state");
        String remoteAddr = row.getString("remoteAddr");
        String remoteHost = row.getString("remoteHost");
        String errorMessage = row.getString("errorMessage");
        String name = row.getString("mailKey");
        Date lastUpdated = row.getTimestamp("lastUpdated");
        Map rawAttributes = row.getMap("attributes", String.class, String.class);
        PerRecipientHeaders perRecipientHeaders = this.fromList(row.getList("perRecipientSpecificHeaders", TupleValue.class));
        MailImpl.Builder mailBuilder = MailImpl.builder().name(name).sender(sender).addRecipients((Collection)recipients).lastUpdated(lastUpdated).errorMessage(errorMessage).remoteHost(remoteHost).remoteAddr(remoteAddr).state(state).addAllHeadersForRecipients(perRecipientHeaders).addAttributes(this.toAttributes(rawAttributes));
        return new CassandraMailRepositoryMailDaoAPI.MailDTO(mailBuilder, this.blobIdFactory.from(row.getString("headerBlobId")), this.blobIdFactory.from(row.getString("bodyBlobId")));
    }

    private List<Attribute> toAttributes(Map<String, String> rowAttributes) {
        return (List)rowAttributes.entrySet().stream().map(Throwing.function(entry -> new Attribute(AttributeName.of((String)((String)entry.getKey())), AttributeValue.fromJsonString((String)((String)entry.getValue()))))).collect(Guavate.toImmutableList());
    }

    private ImmutableList<String> asStringList(Collection<MailAddress> mailAddresses) {
        return (ImmutableList)mailAddresses.stream().map(MailAddress::asString).collect(Guavate.toImmutableList());
    }

    private ImmutableMap<String, String> toRawAttributeMap(Mail mail) {
        return (ImmutableMap)mail.attributes().map(attribute -> Pair.of((Object)attribute.getName().asString(), (Object)this.toJson(attribute.getValue()))).collect(Guavate.toImmutableMap(Pair::getLeft, Pair::getRight));
    }

    private ImmutableList<TupleValue> toTupleList(PerRecipientHeaders perRecipientHeaders) {
        return (ImmutableList)perRecipientHeaders.getHeadersByRecipient().entries().stream().map(entry -> this.userHeaderNameHeaderValueTriple.newValue(new Object[]{((MailAddress)entry.getKey()).asString(), ((PerRecipientHeaders.Header)entry.getValue()).getName(), ((PerRecipientHeaders.Header)entry.getValue()).getValue()})).collect(Guavate.toImmutableList());
    }

    private PerRecipientHeaders fromList(List<TupleValue> list) {
        PerRecipientHeaders result = new PerRecipientHeaders();
        list.forEach(tuple -> result.addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(tuple.getString(1)).value(tuple.getString(2)).build(), this.toMailAddress(tuple.getString(0))));
        return result;
    }

    private String toJson(AttributeValue<?> attributeValue) {
        return attributeValue.toJson().toString();
    }

    private MailAddress toMailAddress(String rawValue) {
        try {
            return new MailAddress(rawValue);
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }
}

