/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.webadmin.dto.QuotaDetailsDTO;
import org.apache.james.webadmin.dto.UsersQuotaDetailsDTO;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;

public class UserQuotaService {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaManager quotaManager;
    private final UserQuotaRootResolver userQuotaRootResolver;
    private final QuotaSearcher quotaSearcher;

    @Inject
    public UserQuotaService(MaxQuotaManager maxQuotaManager, QuotaManager quotaManager, UserQuotaRootResolver userQuotaRootResolver, QuotaSearcher quotaSearcher) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaManager = quotaManager;
        this.userQuotaRootResolver = userQuotaRootResolver;
        this.quotaSearcher = quotaSearcher;
    }

    public void defineQuota(Username username, ValidatedQuotaDTO quota) {
        try {
            QuotaRoot quotaRoot = this.userQuotaRootResolver.forUser(username);
            if (quota.getCount().isPresent()) {
                this.maxQuotaManager.setMaxMessage(quotaRoot, quota.getCount().get());
            } else {
                this.maxQuotaManager.removeMaxMessage(quotaRoot);
            }
            if (quota.getSize().isPresent()) {
                this.maxQuotaManager.setMaxStorage(quotaRoot, quota.getSize().get());
            } else {
                this.maxQuotaManager.removeMaxStorage(quotaRoot);
            }
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    public QuotaDetailsDTO getQuota(Username username) throws MailboxException {
        QuotaRoot quotaRoot = this.userQuotaRootResolver.forUser(username);
        QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
        QuotaDetailsDTO.Builder quotaDetails = QuotaDetailsDTO.builder().occupation((Quota<QuotaSizeLimit, QuotaSizeUsage>)quotas.getStorageQuota(), (Quota<QuotaCountLimit, QuotaCountUsage>)quotas.getMessageQuota());
        this.mergeMaps(this.maxQuotaManager.listMaxMessagesDetails(quotaRoot), this.maxQuotaManager.listMaxStorageDetails(quotaRoot)).forEach(quotaDetails::valueForScope);
        quotaDetails.computed(this.computedQuota(quotaRoot));
        return quotaDetails.build();
    }

    private ValidatedQuotaDTO computedQuota(QuotaRoot quotaRoot) throws MailboxException {
        return ValidatedQuotaDTO.builder().count(this.maxQuotaManager.getMaxMessage(quotaRoot)).size(this.maxQuotaManager.getMaxStorage(quotaRoot)).build();
    }

    private Map<Quota.Scope, ValidatedQuotaDTO> mergeMaps(Map<Quota.Scope, QuotaCountLimit> counts, Map<Quota.Scope, QuotaSizeLimit> sizes) {
        return Sets.union(counts.keySet(), sizes.keySet()).stream().collect(Collectors.toMap(Function.identity(), scope -> ValidatedQuotaDTO.builder().count(Optional.ofNullable((QuotaCountLimit)counts.get(scope))).size(Optional.ofNullable((QuotaSizeLimit)sizes.get(scope))).build()));
    }

    public Optional<QuotaSizeLimit> getMaxSizeQuota(Username username) throws MailboxException {
        return this.maxQuotaManager.getMaxStorage(this.userQuotaRootResolver.forUser(username));
    }

    public void defineMaxSizeQuota(Username username, QuotaSizeLimit quotaSize) throws MailboxException {
        this.maxQuotaManager.setMaxStorage(this.userQuotaRootResolver.forUser(username), quotaSize);
    }

    public void deleteMaxSizeQuota(Username username) throws MailboxException {
        this.maxQuotaManager.removeMaxStorage(this.userQuotaRootResolver.forUser(username));
    }

    public Optional<QuotaCountLimit> getMaxCountQuota(Username username) throws MailboxException {
        return this.maxQuotaManager.getMaxMessage(this.userQuotaRootResolver.forUser(username));
    }

    public void defineMaxCountQuota(Username username, QuotaCountLimit quotaCount) throws MailboxException {
        this.maxQuotaManager.setMaxMessage(this.userQuotaRootResolver.forUser(username), quotaCount);
    }

    public void deleteMaxCountQuota(Username username) throws MailboxException {
        this.maxQuotaManager.removeMaxMessage(this.userQuotaRootResolver.forUser(username));
    }

    public List<UsersQuotaDetailsDTO> getUsersQuota(QuotaQuery quotaQuery) {
        return (List)this.quotaSearcher.search(quotaQuery).stream().map(Throwing.function(user -> UsersQuotaDetailsDTO.builder().user((Username)user).detail(this.getQuota((Username)user)).build())).collect(Guavate.toImmutableList());
    }
}

