/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.task.Task;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverAllTask;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverGroupTask;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverOneTask;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverService;
import reactor.core.publisher.Mono;

public class EventDeadLettersService {
    private final EventDeadLettersRedeliverService redeliverService;
    private final EventDeadLetters deadLetters;

    @Inject
    @VisibleForTesting
    public EventDeadLettersService(EventDeadLettersRedeliverService redeliverService, EventDeadLetters deadLetters) {
        this.redeliverService = redeliverService;
        this.deadLetters = deadLetters;
    }

    public List<String> listGroupsAsStrings() {
        return (List)this.deadLetters.groupsWithFailedEvents().map(Group::asString).collect(Guavate.toImmutableList()).block();
    }

    public List<String> listGroupsInsertionIdsAsStrings(Group group) {
        return (List)this.deadLetters.failedIds(group).map(EventDeadLetters.InsertionId::getId).map(UUID::toString).collect(Guavate.toImmutableList()).block();
    }

    public Mono<Event> getEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return this.deadLetters.failedEvent(group, insertionId);
    }

    public void deleteEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        this.deadLetters.remove(group, insertionId).block();
    }

    public Task redeliverAllEvents() {
        return new EventDeadLettersRedeliverAllTask(this.redeliverService);
    }

    public Task redeliverGroupEvents(Group group) {
        return new EventDeadLettersRedeliverGroupTask(this.redeliverService, group);
    }

    public Task redeliverSingleEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return new EventDeadLettersRedeliverOneTask(this.redeliverService, group, insertionId);
    }
}

