/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.task.Task;
import org.apache.james.webadmin.service.EventRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EventDeadLettersRedeliverService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDeadLettersRedeliverService.class);
    private final EventBus eventBus;
    private final EventDeadLetters deadLetters;

    @Inject
    @VisibleForTesting
    public EventDeadLettersRedeliverService(EventBus eventBus, EventDeadLetters deadLetters) {
        this.eventBus = eventBus;
        this.deadLetters = deadLetters;
    }

    Flux<Task.Result> redeliverEvents(EventRetriever eventRetriever) {
        return eventRetriever.retrieveEvents(this.deadLetters).flatMap(entry -> this.redeliverGroupEvents((Group)entry.getT1(), (Event)entry.getT2(), (EventDeadLetters.InsertionId)entry.getT3()), 16);
    }

    private Mono<Task.Result> redeliverGroupEvents(Group group, Event event, EventDeadLetters.InsertionId insertionId) {
        return this.eventBus.reDeliver(group, event).then(this.deadLetters.remove(group, insertionId)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("Error while performing redelivery of event: {} for group: {}", new Object[]{event.getEventId().toString(), group.asString(), e});
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }
}

